package com.blt.other.module.cost.service.impl;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.blt.other.common.base.SysUser;
import com.blt.other.common.util.SessionUtils;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.module.cost.dao.AccountingSubjectMapper;
import com.blt.other.module.cost.dao.CostTypeDao;
import com.blt.other.module.cost.dto.request.CostTypeImportExcelItem;
import com.blt.other.module.cost.model.AccountingSubject;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/13 3:31 下午
 */
@Slf4j
public class CostTypeImportExcelItemListener extends AnalysisEventListener<CostTypeImportExcelItem> {

    private static final int BATCH_COUNT = 1000;
    List<CostTypeImportExcelItem> list = new ArrayList<>();

    private final Integer costTemplateType;
    private final AccountingSubjectMapper accountingSubjectMapper;
    private final CostTypeDao costTypeDao;

    public CostTypeImportExcelItemListener(Integer costTemplateType, AccountingSubjectMapper accountingSubjectMapper, CostTypeDao costTypeDao) {
        this.costTemplateType = costTemplateType;
        this.accountingSubjectMapper = accountingSubjectMapper;
        this.costTypeDao = costTypeDao;
    }


    @Override
    public void invoke(CostTypeImportExcelItem data, AnalysisContext context) {
        log.info("解析到一条数据:{}", JSON.toJSONString(data));
        list.add(data);
        if (list.size() >= BATCH_COUNT) {
            syncData();
            list.clear();
        }
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        syncData();
        log.info("所有数据解析完成！");
    }

    private void syncData() {
        SysUser sysUser = SessionUtils.getSysUser();


        log.info("{}条数据，开始存储数据库！", list.size());
        list.forEach(item -> {
            AccountingSubject accountingSubject = accountingSubjectMapper.selectByName(item.getAccountingSubjectName());
            if (accountingSubject == null) {
                accountingSubject = new AccountingSubject();
                accountingSubject.setSubjectNo(IdWorker.getIdStr());
                accountingSubject.setName(item.getAccountingSubjectName());
                accountingSubject.setUpdateUserId(sysUser.getOaUserId());
                accountingSubject.setUpdateUser(sysUser.getUserName());
                accountingSubjectMapper.insert(accountingSubject);
                log.info("新增会计科目");
            }

            CostTypeDomain costTypeDomain = costTypeDao.selectOne(new LambdaQueryWrapper<CostTypeDomain>()
                    .eq(CostTypeDomain::getTypeName, item.getTypeName())
                    .eq(CostTypeDomain::getAccountingSubjectNo, accountingSubject.getSubjectNo()));
            if (costTypeDomain == null) {
                costTypeDomain = new CostTypeDomain();
                costTypeDomain.setTypeNo(IdWorker.getIdStr());
                costTypeDomain.setTypeName(item.getTypeName());
                costTypeDomain.setDescription(item.getTypeDesc());
                costTypeDomain.setAccountingSubjectNo(accountingSubject.getSubjectNo());
                costTypeDomain.setCostTemplateType(costTemplateType);

                costTypeDomain.setUpdateUserId(sysUser.getOaUserId());
                costTypeDomain.setUpdateUser(sysUser.getUserName());
                costTypeDao.insert(costTypeDomain);
                log.info("新增费用科目");
            }
        });
        log.info("存储数据库成功！");
    }
}
