package com.blt.other.database.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.blt.other.module.sys.model.CostReviewer;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;


@TableName(value = "cost_company", autoResultMap = true)
@Data
public class CostCompanyDomain {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("费用系统自编no")
    private String companyNo;

    @ApiModelProperty("财务主体名")
    private String companyName;

    private Integer value;

    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private LocalDateTime lastUpdateTime;
    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private LocalDateTime createTime;
    private Integer createUserId;

    private Integer updateUserId;
    private String updateUserName;

    @ApiModelProperty("最终审核人")
    @TableField(exist = false)
    private CostReviewer finalReviewer;

    @ApiModelProperty("财务审核人")
    @TableField(exist = false)
    private List<CostReviewer> financialReviewer;

    @ApiModelProperty("行政审核人")
    @TableField(exist = false)
    private List<CostReviewer> hrReviewer;

    @ApiModelProperty("公司主体编码")
    @TableField(exist = false)
    private String codeName;

    @ApiModelProperty("体系")
    private String companySystem;

}
