package com.bailuntec.cost.api.dto;

import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 工资费用单入参
 * </p>
 *
 * @author robbendev
 * @since 2020/9/18 11:30 上午
 */
@Data
public class WageCostDto {

    //用户ID
    private Integer userId;

    // 费用单金额
    private BigDecimal amount;

    // 币种
    private String currency;

    // 费用单备注
    private String costRemark;

    // 付款理由
    private String costReason;

    //费用来源 1-默认 2-WMS 3-调拨系统 4-工资系统
    private String sourceFrom;

    private String companyName;

    private Integer companyValue;

    //收款/付款银行（或支付宝）
    private String bankName;

    //收款/付款账号
    private String bankCard;

    //收款/付款人（创建人）
    private String bankCardUser;

    //收款/付款单位
    private String bankCompany;

    //附件外链地址
    private String fileUrl;

    //所属项目
    private String project;

    //所属账期
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date projectDate;
    //所属账期
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date projectDateA;

    private List<WageCostDetailDto> listDetail;
    
}
