package com.blt.other.module.cost.service.impl;

import com.bailuntec.common.ListUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.module.auth.dao.CostReviewerMapper;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.dto.request.CompanyReviewerListReq;
import com.blt.other.module.auth.model.CostReviewer;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.common.util.CompanyUtil;
import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.module.cost.service.CostCompanyService;
import com.blt.other.module.database.model.CostCompanyDomain;
import com.blt.other.module.purchasing.vo.CompanyVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

@Service
public class CostCompanyServiceImpl extends ServiceImpl<CostCompanyDao, CostCompanyDomain> implements CostCompanyService {
    private static Logger logger = LoggerFactory.getLogger(CostCompanyServiceImpl.class);

    @Autowired
    private CostCompanyDao costCompanyDao;
    @Value("${url.api.postCompanyListApi}")
    private String postCompanyListApi;
    @Autowired
    CostReviewerMapper costReviewerMapper;
    @Autowired
    OaUserMapper oaUserMapper;


    @Override
    public String syncCompany() {

        List<CompanyVo> companyList = CompanyUtil.getCompanyList(postCompanyListApi);
        int result = 0;
        Integer update = 0;
        if (companyList != null && companyList.size() >= 1) {
            CostCompanyDomain companyDomain = null;
            for (CompanyVo companyVo : companyList) {
                // 根据公司名称判断是否已经存在公司主体
                companyDomain = new CostCompanyDomain();
                companyDomain.setValue(companyVo.getValue());
                companyDomain.setCompanyName(companyVo.getName());
                List<CostCompanyDomain> costCompanyDomains = costCompanyDao.selectByNameOrValue(companyDomain);
                if (null != costCompanyDomains && costCompanyDomains.size() >= 1) {
                    // 如果表中已存在相同名称的主体，则 update（根据 companyNo）
                    String companyNo = costCompanyDomains.get(0).getCompanyNo();
                    companyDomain.setCompanyNo(companyNo);
                    if (isUpdate(costCompanyDomains.get(0), companyDomain)) {
                        Integer Integer = costCompanyDao.update(companyDomain);
                        update += Integer;
                        if (Integer >= 1) {
                            logger.warn("主体" + companyDomain + "已更新费用管理系统记录");
                        }
                    }
                } else {
                    companyDomain.setCompanyNo(createCompanyNo());
                    costCompanyDao.insertCompany(companyDomain);
                    result += 1;
                    logger.warn("主体：" + companyDomain + " 已加入费用管理系统");
                }
            }
        }
        return "新增 " + result + " 条记录，更新 " + update + " 条记录";
    }

    @Override
    public List<CostCompanyDomain> getAllCompany() {
        return costCompanyDao.selectAll();
    }

    @Override
    public List<CostCompanyDomain> getAllCompanyAuthority() {
        return costCompanyDao.getAllCompanyAuthority();
    }

    /**
     * 根据 companyNo 获取 company
     *
     * @param companyNo
     * @return
     */
    @Override
    public CostCompanyDomain getCompanyByCompanyNo(String companyNo) {
        return costCompanyDao.selectByNo(companyNo);
    }

    @Override
    public IPage<CostCompanyDomain> reviewerList(CompanyReviewerListReq req) {

        IPage<CostCompanyDomain> page = new Page<>(req.getPageNum(), req.getPageSize());

        page = baseMapper.reviewerList(page, req);

        if (ListUtil.isNotEmpty(page.getRecords())) {
            List<Integer> costCompanyIds = page.getRecords().stream().map(CostCompanyDomain::getId).collect(Collectors.toList());

            //最终审核人
            List<CostReviewer> finalCostReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .in(CostReviewer::getReferId, costCompanyIds)
                    .eq(CostReviewer::getType, CostReviewer.finalReviewer));

            Map<Integer, CostReviewer> finalReviewerMap = finalCostReviewerList.stream().collect(Collectors.toMap(CostReviewer::getReferId, costReviewer -> costReviewer));
            page.getRecords().forEach(record -> record.setFinalReviewer(finalReviewerMap.get(record.getId())));

            //财务审核人
            List<CostReviewer> financialCostReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .in(CostReviewer::getReferId, costCompanyIds)
                    .eq(CostReviewer::getType, CostReviewer.financialReviewer));

            Map<Integer, List<CostReviewer>> financialReviewerMap = financialCostReviewerList.stream().collect(Collectors.groupingBy(CostReviewer::getReferId));
            page.getRecords().forEach(record -> {
                record.setFinancialReviewer(financialReviewerMap.get(record.getId()));
            });
        }

        return page;
    }

    @Override
    public void modifyFinalReviewer(Integer userId, List<String> companyNoList, Integer finalReviewerUserId) {

        companyNoList.forEach(companyNo -> {
            OaUser currentOaUser = oaUserMapper.selectByOaUserId(userId);
            CostCompanyDomain costCompanyDomain = baseMapper.selectByNo(companyNo);

            //记录更新时间
            costCompanyDomain.setLastUpdateTime(LocalDateTime.now());
            costCompanyDomain.setUpdateUserId(userId);
            costCompanyDomain.setUpdateUserName(currentOaUser.getUserName());
            baseMapper.updateById(costCompanyDomain);


            //删除旧审核人
            costReviewerMapper.delete(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, CostReviewer.finalReviewer)
                    .eq(CostReviewer::getReferId, costCompanyDomain.getId()));


            //新增审核人
            OaUser oaUser = oaUserMapper.selectByOaUserId(finalReviewerUserId);
            CostReviewer costReviewer = CostReviewer.builder()
                    .reviewerUserId(finalReviewerUserId)
                    .reviewerUserName(oaUser.getUserName())
                    .referId(costCompanyDomain.getId())
                    .type(CostReviewer.finalReviewer)
                    .build();

            costReviewerMapper.insert(costReviewer);
        });
    }

    @Override
    public void modifyFinancialReviewer(Integer userId, List<String> companyNoList, List<Integer> financialReviewerUserIdList) {

        companyNoList.forEach(companyNo -> {
            OaUser currentOaUser = oaUserMapper.selectByOaUserId(userId);
            CostCompanyDomain costCompanyDomain = baseMapper.selectByNo(companyNo);

            //记录更新时间
            costCompanyDomain.setLastUpdateTime(LocalDateTime.now());
            costCompanyDomain.setUpdateUserId(userId);
            costCompanyDomain.setUpdateUserName(currentOaUser.getUserName());
            baseMapper.updateById(costCompanyDomain);

            //删除旧审核人
            costReviewerMapper.delete(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, CostReviewer.financialReviewer)
                    .eq(CostReviewer::getReferId, costCompanyDomain.getId()));

            financialReviewerUserIdList.forEach(financialReviewerUserId -> {
                //新增审核人
                OaUser financialReviewerOaUser = oaUserMapper.selectByOaUserId(financialReviewerUserId);
                CostReviewer costReviewer = CostReviewer.builder()
                        .reviewerUserId(financialReviewerUserId)
                        .reviewerUserName(financialReviewerOaUser.getUserName())
                        .referId(costCompanyDomain.getId())
                        .type(CostReviewer.financialReviewer)
                        .build();

                costReviewerMapper.insert(costReviewer);
            });
        });


    }

    /**
     * 生成唯一的主体编号
     *
     * @return
     */
    private String createCompanyNo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        Random random = new Random();
        String companyNo = "COM" + sdf.format(new Date()) + random.nextInt(9);
        CostCompanyDomain companyDomain = costCompanyDao.selectByNo(companyNo);
        while (null != companyDomain && null != companyDomain.getCompanyName()) {
            companyNo = "COM" + sdf.format(new Date()) + random.nextInt(9);
            companyDomain = costCompanyDao.selectByNo(companyNo);
        }
        return companyNo;
    }

    private boolean isUpdate(CostCompanyDomain exited, CostCompanyDomain forInsert) {
        String companyName = exited.getCompanyName();
        Integer value = exited.getValue();
        String companyName1 = forInsert.getCompanyName();
        Integer value1 = forInsert.getValue();
        if (("" + companyName).equals("" + companyName1) && value == value1) {
            return false;
        }
        return true;
    }
}
