package com.blt.other.module.cost.service;

import com.blt.other.module.cost.dto.CostPlanApiDto;
import com.blt.other.module.database.model.CostPlanDomain;

public interface CostPlanService {

    /**
     * <p>
     * 创建费用计划编号
     * </p>
     *
     * @return 费用计划编号
     */
    String createNo();

    /**
     * <p>
     * 保存费用计划
     * </p>
     *
     * @param planDomain 费用计划
     */
    void save(CostPlanDomain planDomain);


    /**
     * <p>
     * 更新费用计划
     * </p>
     *
     * @param planDomain 费用计划
     */
    void update(CostPlanDomain planDomain);

    /**
     * <p>
     * 确认费用计划
     * </p>
     *
     * @param costPlanNo 费用计划编号
     */
    Integer affirm(String costPlanNo);

    /**
     * <p>
     * 删除费用计划
     * </p>
     *
     * @param costPlanNo 费用计划编号
     */
    void deleted(String costPlanNo);

    /**
     * <p>
     * 查询所有费用计划
     * </p>
     *
     * @param userId 当前登录用户oa userid
     * @return 所有费用计划
     */
    CostPlanApiDto.GetAllCostPlanResp getAllCostList(CostPlanApiDto.GetAllCostPlanReq userId);

    /**
     * <p>
     * 根据费用计划编号 获取费用计划详情
     * </p>
     *
     * @param planNo 费用计划编号
     * @return 费用计划详情
     */
    CostPlanApiDto.GetCostPlanResp getByPlanNo(String planNo);
}
