package com.blt.other.module.cost.dto;

import com.bailuntec.cost.api.dto.CostPlanTempDto;
import com.blt.other.module.database.model.CostPlanTempDomain;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import org.springframework.web.multipart.MultipartFile;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/15 1:31 下午
 */
public final class CostPlanTempApiDto {

    @ApiModel("添加费用计划子项响应结果")
    @Data
    public static class AddItemResp {
        private CostPlanTempDomain tmp;
        private String msg;
        private Boolean success;
        private BigDecimal plaAmount;
    }

    @ApiModel("添加费用计划子项响应入参")
    @Data
    public static class AddItemReq {
        // 费用单表 id
        private Integer id;
        private String costPlanNo; // 费用计划编号
        private String tempNo; // 计划缓存编号
        private String kindNo; // 种类编号
        private String filePath; // 文件地址
        private BigDecimal amount; // 费用总金额
        private String costReason; // 付款理由
        private String dic; // 币种
        private String typeNo; // 大类编号

        private BigDecimal planAmount;
        private MultipartFile fileSelect;
    }

    @ApiModel("获取费用计划编号对应的费用计划子项出参")
    @Data
    public static class GetCostTempByPlanNoResp {

        private List<CostPlanTempDto> temps;
        private BigDecimal planAmount;
        private Boolean success;
    }

    @ApiModel("删除费用计划模版行项目出参")
    @Data
    public static class DeleteItemResp {
        private Boolean success;
        private String msg;
        private BigDecimal planAmount;
    }

    @ApiModel("根据费用计划模板编号获取费用计划模版出参")
    @Data
    public static class GetByTempNoResp {
        private CostPlanTempDto tmp;
    }

    @ApiModel("更新费用计划子项入参")
    @Data
    public static class ResetItemReq {

        private Integer id;
        private String costPlanNo; // 费用计划编号
        private String tempNo; // 计划缓存编号
        private String kindNo; // 种类编号
        private String filePath; // 文件地址
        private BigDecimal amount; // 费用总金额
        private String costReason; // 付款理由
        private String dic; // 币种
        private String typeNo; // 大类编号

        private Boolean delecteFile;
        private MultipartFile fileSelect2;
    }

    @ApiModel("更新费用计划子项出参")
    @Data
    public static class ResetItemResp {
        private Boolean success;
        private CostPlanTempDomain tmp;
    }
}
