package com.blt.other.common.util;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

import oauth.signpost.OAuthConsumer;
import oauth.signpost.basic.HttpURLConnectionResponseAdapter;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthProvider;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.http.HttpParameters;
import oauth.signpost.signature.AuthorizationHeaderSigningStrategy;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.util.ObjectUtils;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in 14:29 2021-04-24
 * @Modified by:
 */
public class OAuth1Util {
    private static OAuthConsumer oAuthConsumer;

    /**
     * 设置认证参数
     * @param consumerKey
     * @param consumerSecret
     * @param accessToken
     * @param accessTokenSecret
     * @param realmID
     */
    public static void setupContext(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret, String realmID) {
        HttpParameters httpParameters = new HttpParameters();
        httpParameters.put("realm", realmID);
        oAuthConsumer = new CommonsHttpOAuthConsumer(consumerKey, consumerSecret);
        oAuthConsumer.setTokenWithSecret(accessToken, accessTokenSecret);
        oAuthConsumer.setAdditionalParameters(httpParameters);
        oAuthConsumer.setSigningStrategy(new AuthorizationHeaderSigningStrategy());
    }

    /**
     * 认证
     * @param httpRequest
     * @throws Exception
     */
    private static void authorize(HttpRequestBase httpRequest) throws Exception {
        try {
            oAuthConsumer.sign(httpRequest);
        } catch (OAuthMessageSignerException e) {
            throw new Exception(e);
        } catch (OAuthExpectationFailedException e) {
            throw new Exception(e);
        } catch (OAuthCommunicationException e) {
            throw new Exception(e);
        }
    }

    /**
     * 请求，Json Post
     * @param customURIString
     * @param header 请求头，已经默认了application/json
     * @param parameter Json数据
     * @return
     * @throws Exception
     */
    public static HttpResponse executePost(String customURIString, Map<String, String> header, String parameter) throws Exception {

        CloseableHttpClient client = HttpClients.createDefault();
        URIBuilder builder = null;
        builder = new URIBuilder(customURIString);
        HttpPost request = new HttpPost(builder.build());
        HttpEntity httpEntity = new StringEntity(parameter, "application/json", "utf-8");
        request.setEntity(httpEntity);
        if (!ObjectUtils.isEmpty(header)) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
        }
        authorize(request);

        HttpClient httpClient = new DefaultHttpClient();
        return httpClient.execute(request);
    }
}
