package com.bailuntec.cost.api.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class ManageCostDto {

    // 费用单号或采购单号
    private String no;

    // 收款单位
    private String receiveUnit;
    // 收款银行
    private String receiveBank;
    // 收款卡号
    private String receiveCard;
    // 收款用户
    private String receiveCardUser;
    // 理由/用途
    private String reason;
    //备注
    private String remark;

    // 付款时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JSONField(name = "cashier_time", format = "yyyy-MM-dd HH:mm:ss")
    private Date payTime;

    // 费用付款单同cost_form=1，费用借还单同cost_form=3，采购单为0
    private Integer manageCostType;
    // 部门
    private String departmentName;
    // 公司主体value
    private Integer companyValue;
    // 付款主体
    private String companyName;
    //会计科目
    private String accountingSubjectName;
    // 费用大类
    private String feeSuperType;
    // 费用小类
    private String feeSubType;
    // 金额
    private BigDecimal amount;
    // 币种
    private String currency;
    // 人民币金额
    private BigDecimal amountRmb;
    //费用单Id
    private Integer costId;
    //费用单详情Id
    private Integer costId1;
}
