package com.blt.other.module.cost.controller;

import com.blt.other.module.cost.vo.ApplyCallbackUrlVo;
import com.blt.other.module.cost.vo.CashierCallbackUrlVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
@Api(tags = "4k api")
@RestController
@RequestMapping("/cost/api/4k")
public class CostApi4k {
    @Resource
    private RestTemplate restTemplate;

    private final static String BASE_URL = "https://oa.4kmiles.com/costApi/purchase/other";

    @ApiOperation("审核回调地址")
    @PostMapping(value = "/purchasing/ApplyCallbackUrl",consumes = "application/json")
    public String applyCallbackUrl(HttpServletRequest request){
        ResponseEntity<String> responseEntity = restTemplate.postForEntity(BASE_URL + "/purchasing/list/detail/ApplyCallbackUrl", request,String.class);
        return responseEntity.getBody();
    }

    @ApiOperation("出纳回调地址")
    @PostMapping(value = "/purchasing/CashierCallbackUrl", consumes = "application/json")
    public String cashierCallbackUrl(HttpServletRequest request){
        ResponseEntity<String> responseEntity = restTemplate.postForEntity(BASE_URL + "/purchasing/list/detail/ApplyCallbackUrl", request,String.class);
        return responseEntity.getBody();
    }

    @ApiOperation("财务审核回调")
    @PostMapping("/check/ApplyCallbackUrl")
    public Map<String, Object> applyCallbackUrl(@RequestBody ApplyCallbackUrlVo applyCallbackUrlVo){
        ResponseEntity<Map> responseEntity = restTemplate
                .postForEntity(BASE_URL + "/cost/check/ApplyCallbackUrl"
                        , applyCallbackUrlVo,Map.class);
        return responseEntity.getBody();
    }

    @ApiOperation("财务付款回调接口")
    @PostMapping("/check/CashierCallbackUrl")
    public Map<String, Object> cashierCallbackUrl(@RequestBody CashierCallbackUrlVo cashierCallbackUrlVo){
        ResponseEntity<Map> responseEntity = restTemplate
                .postForEntity(BASE_URL + "/cost/check/CashierCallbackUrl"
                        , cashierCallbackUrlVo,Map.class);
        return responseEntity.getBody();
    }
}
