package com.blt.other.module.cost.service.impl;

import com.alibaba.excel.EasyExcel;
import com.bailuntec.common.BeanUtils;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.database.model.LogisticsSupplierBankDomain;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.cost.dao.AccountingSubjectMapper;
import com.blt.other.module.cost.dao.CostTypeDao;
import com.blt.other.module.cost.dto.request.*;
import com.blt.other.module.cost.dto.response.CostTypeExportExcelItem;
import com.blt.other.module.cost.dto.response.CostTypeResult;
import com.blt.other.module.cost.dto.response.GetLogisticsBankResp;
import com.blt.other.module.cost.dto.response.GetLogisticsCodeResp;
import com.blt.other.module.cost.service.CostTypeKindService;
import com.blt.other.module.cost.service.CostTypeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

@Service
@Slf4j
public class CostTypeServiceImpl extends ServiceImpl<CostTypeDao, CostTypeDomain> implements CostTypeService {
    @Resource
    AccountingSubjectMapper accountingSubjectMapper;
    @Resource
    OaUserMapper oaUserMapper;

    @Override
    public void addCostType(CostTypeAddReq req) {
        CostTypeDomain costTypeDomain = new CostTypeDomain();
        costTypeDomain.setAccountingSubjectNo(req.getAccountingSubjectNo());
        costTypeDomain.setTypeNo(IdWorker.getIdStr());
        costTypeDomain.setTypeName(req.getTypeName());
        costTypeDomain.setDescription(req.getDescription());

        costTypeDomain.setIsManageCost(req.getIsManageCost());

        costTypeDomain.setCostTemplateType(this.getCostTemplateType(req.getType()));

        this.save(costTypeDomain);

        if (req.getType().equals(1)) {
            CostTypeDomain lendCostTypeDomain = new CostTypeDomain();
            lendCostTypeDomain.setCostTemplateType(CostTypeDomain.borrow);
            lendCostTypeDomain.setAccountingSubjectNo("1345912843756503041");
            lendCostTypeDomain.setTypeNo(IdWorker.getIdStr());
            lendCostTypeDomain.setTypeName(req.getTypeName());
            lendCostTypeDomain.setDescription(req.getDescription());
        }

    }

    @Override
    public Page<CostTypeResult> queryPage(CostTypeQueryPageReq req) {
        IPage<CostTypeResult> page = new Page<>(req.getPageNum(), req.getPageSize());

        req.setCostTemplateType(this.getCostTemplateType((req.getType())));
        page = baseMapper.queryPage(page, req);
        return (Page<CostTypeResult>) page;
    }

    @Override
    public void modifyCostType(CostTypeModifyReq req) {
        OaUser oaUser = oaUserMapper.selectByOaUserId(req.getCurrentUserId());


        log.info("{} 更新费用类型", oaUser.getUserName());
        if (req.getTypeNo() != null) {
            CostTypeDomain costTypeDomain = baseMapper.selectByNo(req.getTypeNo());
            costTypeDomain.setTypeName(req.getTypeName().trim());
            costTypeDomain.setDescription(req.getDescription());
            costTypeDomain.setUpdateUserId(oaUser.getOaUserId());
            costTypeDomain.setUpdateUser(oaUser.getUserName());
            costTypeDomain.setLastUpdateTime(LocalDateTime.now());
            costTypeDomain.setAccountingSubjectNo(req.getAccountingSubjectNo());

            costTypeDomain.setIsManageCost(req.getIsManageCost());

            log.info("{} 更新会计一级科目", oaUser.getUserName());

            this.updateById(costTypeDomain);
        }
    }

    @Override
    public CostTypeResult queryDetail(Integer id) {
        return baseMapper.queryDetail(id);
    }

    @Override
    public void deleteById(Integer id) {
        baseMapper.deleteById(id);
    }

    @Override
    public CostTypeResult queryByNo(String typeNo) {
        return baseMapper.queryByNo(typeNo);
    }

    @Override
    public GetLogisticsCodeResp getLogisticsCode() {
        GetLogisticsCodeResp resp = new GetLogisticsCodeResp();
        resp.setSuccess(true);
        resp.setLogisticsCode("22222");
        return resp;
    }

    @Resource
    CostTypeKindService costTypeKindService;

    @Override
    public GetLogisticsBankResp getLogisticsBank(String subSupplierName) {
        GetLogisticsBankResp resp = new GetLogisticsBankResp();
        resp.setSuccess(true);
        LogisticsSupplierBankDomain bankDomain = costTypeKindService.getLogisticsBank(subSupplierName);
        resp.setBankInfo(bankDomain);
        return resp;
    }


    @Override
    public void importExcel(CostTypeImportExcelReq req) throws IOException {

        CostTypeImportExcelItemListener costTypeImportExcelItemListener = new CostTypeImportExcelItemListener(
                this.getCostTemplateType(req.getType()),
                accountingSubjectMapper,
                baseMapper
        );
        EasyExcel.read(req.getExcel().getInputStream(), CostTypeImportExcelItem.class, costTypeImportExcelItemListener).sheet().doRead();
    }

    @Override
    public void exportExcel(HttpServletResponse response, CostTypeExportExcelReq req) throws IOException {

        // 这里注意 有同学反应使用swagger 会导致各种问题，请直接用浏览器或者用postman
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode(IdWorker.getIdStr(), "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");

        req.setCostTemplateType(this.getCostTemplateType(req.getType()));

        List<CostTypeExportExcelItem> list = baseMapper.queryAll(req)
                .stream()
                .map(costTypeResult -> {
                    CostTypeExportExcelItem item = new CostTypeExportExcelItem();
                    BeanUtils.copyProperties(costTypeResult, item);
                    return item;
                })
                .collect(Collectors.toList());

        EasyExcel.write(response.getOutputStream(), CostTypeExportExcelItem.class)
                .sheet("sheet")
                .doWrite(list);
    }

    /**
     * 根据ui类型获取费用类型 对应的费用模版类型
     *
     * @param type 1-费用类型 2-收入类型 3-借支类型
     * @return res
     */
    private Integer getCostTemplateType(Integer type) {
        if (type.equals(1)) {
            return CostTypeDomain.feeType;
        } else if (type.equals(2)) {
            return CostTypeDomain.incomeType;
        } else if (type.equals(3)) {
            return CostTypeDomain.borrow;
        } else {
            throw new BizRuntimeException("invalid type");
        }
    }

}
