package com.blt.other.module.cost.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class CostExportVo {
    private ExportNos params;

    @Data
    public static class ExportNos {
        private List<String> exportNos;
        private Integer userid;
        private String key;
        private Keys keys;

        @Data
        public static class Keys {
            private String companyNo;
            private Integer costForm;
            private String createUsercode;
            private Integer costStatus;
            private Integer lendStatus;
            private Integer isTax;
            private Integer isLend;

            @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
            private Date beginTime;
            @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
            private Date endTime;
            @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
            private Date beginPayTime;
            @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
            private Date endPayTime;
            private String linkCost;
            private Integer financialAuditUserId;
        }
    }
}
