package com.blt.other.module.cost.utils;

import com.bailuntec.common.SpringContextUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.model.CostDomain;

import java.text.NumberFormat;

/**
 * 费用工具类
 */
public class CostUtils {

    public static String getIdNum() {

        String activeProfile = SpringContextUtil.getString("spring.profiles.active");
        /*
        if (!activeProfile.equals("prod")) {
            return IdWorker.getIdStr();
        }
        */
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumIntegerDigits(6);
        nf.setMinimumIntegerDigits(6);

        CostDao costDao = SpringContextUtil.getBean(CostDao.class);

        String result = "";
        CostDomain lastCost = costDao.selectLastCost();
        if (null == lastCost) {
            result = nf.format(0);
        } else {
            String costNo = lastCost.getCostNo();
            if (costNo != null && costNo.contains("-")) {
                costNo = costNo.split("-")[0];
            }
            if (null != costNo && (costNo.startsWith("F"))) {
                String[] os = costNo.split("F");
                result = nf.format(Integer.parseInt(os[1]) + 1);
            } else if (null != costNo && costNo.startsWith("SF")) {
                String[] os = costNo.split("F");
                result = nf.format(Integer.parseInt(os[1]) + 1);
            }
            if (null == costNo) {
                return "F000000";
            }
        }
        return "F" + result;
    }
}
