package com.blt.other.module.cost.service;

import com.blt.other.module.cost.dto.response.GetByKeyResp;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.vo.CostListSearchKeysVo;

import java.util.List;

public interface CostListSearchService {

    /**
     * 通过关键字模糊查询
     *
     * @param key key
     * @return res
     */
    GetByKeyResp searchByKey(String key, int pageNum, int pageSize);

    /**
     * 多条件筛选
     *
     * @param searchKeysVo param
     * @return res
     */
    GetByKeyResp searchByKeys(CostListSearchKeysVo searchKeysVo);

    /**
     * 获取借支单列表
     *
     * @return 借支单列表
     */
    List<CostDomain> getLinkCost();

}
