package com.blt.other.module.cost.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.LocalDateTime;

/**
 * <p>
 * 费用单模版
 * </p>
 *
 * @author robbendev
 * @since 2020-10-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CostTemplateCol对象", description = "费用单模版")
public class CostTemplateCol implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "费用单id")
    private Integer costTemplateId;

    @ApiModelProperty(value = "费用单基础字段id")
    private Integer costTemplateBaseColId;

    @ApiModelProperty(value = "1 = ;2 != ;3 < ;4 <= ;5 > ;6 >= ;7 list contain (校验值用逗号分隔) ;8 ! list contain  (校验值用逗号分隔) ")
    private Integer autoRuleType;

    @ApiModelProperty(value = "自动校验的校验值 cost_col_type在程序做类型转换 写入的时候也要校验类型")
    private String autoRuleCheckVal;

    @ApiModelProperty(value = "是否必填")
    private Boolean isRequired;

    @ApiModelProperty("是否默认模版字段")
    private Boolean isDefault;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createTime;

    private Integer createUserId;
    private String createUserName;

    private Integer updateUserId;
    private String updateUserName;

    @ApiModelProperty(value = "更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime lastUpdateTime;

    private String companyScope;

    private String companyScopeStr;

    @TableField(exist = false)
    private CostTemplateBaseCol costTemplateBaseCol;


    /**
     * 自动校验校准
     *
     * @param costDomain
     * @return
     */
    public Boolean ruleCheck(CostDomain costDomain) {

        try {
            Class<CostDomain> clazz = CostDomain.class;
            Field field = clazz.getDeclaredField(this.costTemplateBaseCol.getColName());
            field.setAccessible(true);
            Object fieldVar = field.get(costDomain);
            switch (autoRuleType) {
                case 1:
                    return autoRuleCheckVal.compareTo(fieldVar.toString()) == 0;
                case 2:
                    return autoRuleCheckVal.compareTo(fieldVar.toString()) != 0;
                case 3:
                    return autoRuleCheckVal.compareTo(fieldVar.toString()) < 0;
                case 4:
                    return autoRuleCheckVal.compareTo(fieldVar.toString()) <= 0;
                case 5:
                    return autoRuleCheckVal.compareTo(fieldVar.toString()) > 0;
                case 6:
                    return autoRuleCheckVal.compareTo(fieldVar.toString()) >= 0;
                case 7:
                    return Lists.newArrayList(autoRuleCheckVal.split(",")).contains(fieldVar.toString());
                case 8:
                    return !Lists.newArrayList(autoRuleCheckVal.split(",")).contains(fieldVar.toString());
                //不用自动校验
                default:
                    return true;
            }
        } catch (Exception e) {
            return false;
        }
    }
}
