package com.blt.other.module.cost.model;

import com.bailuntec.common.BeanUtils;
import com.bailuntec.cost.api.dto.CostDetailDto;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@TableName("cost_detail")
public class CostDetailDomain {

    @TableId(type = IdType.AUTO)
    private Integer id;
    @ApiModelProperty("费用详情编号")
    private String detailNo;
    @ApiModelProperty("费用单编号")
    private String costNo;


    @ApiModelProperty("类型编号")
    private Integer typeId;
    @ApiModelProperty("类型编号")
    private String typeNo;
    @ApiModelProperty("类型标题")
    private String typeName;
    @ApiModelProperty("内部分类")
    private String typeInnerName;
    @ApiModelProperty("类型类别")
    private String categoryName;

    @TableField(exist = false)
    @ApiModelProperty("描述")
    private String description;

    @TableField(exist = false)
    private Integer accountingSubjectId;

    @ApiModelProperty("会计一级科目")
    private String accountingSubjectNo;
    @ApiModelProperty("会计一级科目")
    private String accountingSubjectName;

    @ApiModelProperty("创建人id")
    private Integer createUserid;
    @ApiModelProperty("创建人名称")
    private String createUsername;
    @ApiModelProperty("付款理由")
    private String costReason;

    @ApiModelProperty("费用详情金额")
    private BigDecimal amount;
    @ApiModelProperty("币种")
    private String dic;
    @ApiModelProperty("借支单-借支类型")
    private String lendType;
    @ApiModelProperty("文件地址")
    private String filePath;

    @ApiModelProperty("项目")
    private String projectType;
    @ApiModelProperty("客户编号")
    private String customerNum;

    @ApiModelProperty("所属项目")
    private String project;
    @ApiModelProperty("所属账期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectDate;
    @ApiModelProperty("所属账期A")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectDateA;

    public CostDetailDto castToDto() {
        CostDetailDto costDetailDto = new CostDetailDto();
        BeanUtils.copyProperties(this, costDetailDto);
        return costDetailDto;
    }
}

