package com.blt.other.module.cost.controller;


import com.bailuntec.cost.api.response.CostResult;
import com.blt.other.module.cost.dto.request.AddReq;
import com.blt.other.module.cost.model.CostTemplateBaseCol;
import com.blt.other.module.cost.service.ICostTemplateBaseColService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 费用单基础字段 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-10-14
 */
@Api(tags = "费用单基础字段接口")
@RestController
@RequestMapping("/costTemplateBaseCol")
public class CostTemplateBaseColController {

    @Resource
    ICostTemplateBaseColService costTemplateBaseColService;

    @ApiOperation("获取所有费用单基础字段")
    @GetMapping("/listAll")
    public CostResult<List<CostTemplateBaseCol>> listAll() {
        List<CostTemplateBaseCol> list = costTemplateBaseColService.listAll();
        return CostResult.success(list);
    }

    @ApiOperation("新增费用单基础字段")
    @PostMapping("/add")
    public CostResult<CostTemplateBaseCol> add(@RequestBody AddReq req) {
        CostTemplateBaseCol costTemplateBaseCol = costTemplateBaseColService.add(req);
        return CostResult.success(costTemplateBaseCol);
    }

    @ApiOperation("更新费用单基础字段")
    @PostMapping("/modify")
    public CostResult<Void> modify(@RequestBody CostTemplateBaseCol costTemplateBaseCol) {
        costTemplateBaseColService.modify(costTemplateBaseCol);
        return CostResult.success();
    }

    @ApiOperation("删除费用单基础字段")
    @PostMapping("/delete")
    public CostResult<Void> delete(@RequestParam Integer id) {
        costTemplateBaseColService.delete(id);
        return CostResult.success();
    }

}
