package com.blt.other.common.job;


import com.blt.other.common.job.CostStatusSyncJob;
import org.quartz.*;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CostStatusSyncConfiguration {


    // 扫描主体列表时间间隔：（秒）
    private static final int TIME = 86400;

    // JobDetail 定义要执行的 job
    @Bean
    public JobDetail costStatusSyncJobJobDetail(){
        return JobBuilder.newJob(CostStatusSyncJob.class)
                .withIdentity("costStatusSyncJob")
                .storeDurably().build();
    }

    // 触发 Bean 的 Trigger
    @Bean
    public Trigger costStatusSyncJobTrigger(){
        SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule()
                .withIntervalInSeconds(TIME).repeatForever();
        return TriggerBuilder.newTrigger().forJob(costStatusSyncJobJobDetail())
                .withIdentity("costStatusSuncTrigger")
                .withSchedule(simpleScheduleBuilder).build();
    }
}
