package com.bailuntec.cost.api.dto;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/29 10:22 上午
 */
@Data
public class CostTemplateColDto {
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "费用单id")
    private Integer costTemplateId;

    @ApiModelProperty(value = "费用单基础字段id")
    private Integer costTemplateBaseColId;

    @ApiModelProperty(value = "1 = ;2 != ;3 < ;4 <= ;5 > ;6 >= ;7 list contain (校验值用逗号分隔) ;8 ! list contain  (校验值用逗号分隔) ")
    private Integer autoRuleType;

    @ApiModelProperty(value = "自动校验的校验值 cost_col_type在程序做类型转换 写入的时候也要校验类型")
    private String autoRuleCheckVal;

    @ApiModelProperty(value = "是否必填")
    private Boolean isRequired;

    @ApiModelProperty("是否默认模版字段")
    private Boolean isDefault;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    private Integer createUserId;
    private String createUserName;

    private Integer updateUserId;
    private String updateUserName;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime lastUpdateTime;

    private String companyScope;

    private String companyScopeStr;

    @TableField(exist = false)
    private CostTemplateBaseColDto costTemplateBaseCol;
}
