package com.blt.other.module.cost.service.impl.costcheck;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.database.model.CostLogDomain;
import com.blt.other.module.auth.dao.OaDepartmentMapper;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.module.cost.model.ApprovalHistoryDomain;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.model.CostTemplate;
import com.blt.other.module.cost.service.ApprovalHistoryService;
import com.blt.other.module.sys.model.CostReviewer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.thymeleaf.util.StringUtils;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/30 2:57 下午
 */
@Component
@Scope("prototype")
public class HrCheckState extends CostState {

    @Autowired
    FinancialCheckState financialCheckState;
    @Resource
    GeneralManagerCheckState generalManagerCheckState;
    @Resource
    OaDepartmentMapper oaDepartmentMapper;
    @Resource
    OaUserMapper oaUserMapper;
    @Resource
    CostCompanyDao costCompanyDao;
    @Resource
    ApprovalHistoryService approvalHistoryService;

    @Override
    public void handle(String reason) {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;
        CostTemplate costTemplate = costTemplateService.queryDetail(costDomain.getCostTemplateId());

        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_HR_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }

        //如果不需要审核 直接通过
        if (!costTemplate.shouldHrCheck(costDomain)) {
            //2022-02-11后"广州沃伟科技发展有限公司"不用总经办审核,直接转财务审核
            //2024-07-01后付款主体为“印尼”且币种“IDR”不用总经办审核,直接转财务审核
            //2024-07-02后付款主体为“印尼”,“广州赵赵生活科技有限公司”,“zhaozhao life tech limited”,“广州行思数据科技有限公司”不用总经办审核,直接转财务审核
            String[] companyNos = {"COM2008121838151", "COM2306081104478", "COM2404251335512", "COM2405061041166", "COM2405161425523"};
            boolean isFinancialCheck = Arrays.asList(companyNos).contains(costDomain.getCompanyNo());
            costDomain.setCostStatus(isFinancialCheck ? CostDomain.STATUS_FINANCIAL_CHECK : CostDomain.STATUS_MANAGER_CHECK);
            costDomain.setLastModifyDate(LocalDateTime.now());
            costDao.updateById(costDomain);

            //流转状态
            nextState(isFinancialCheck ? financialCheckState : generalManagerCheckState);
            costSubscribe.subscribe(costContext);

            return;
        }

        //人工审核
        if (costContext.currentUserId != null) {
            //人工审核通过
            if (costCurrentReviewerService.canAudit(currentUserId, costDomain.getCostNo())) {
                ApprovalHistoryDomain approvalHistoryDomain = ApprovalHistoryDomain.builder()
                        .approvalUserId(currentUserId)
                        .approvalTime(LocalDateTime.now())
                        .costStatus(costDomain.getCostStatus())
                        .costNo(costDomain.getCostNo())
                        .isPassed(true)
                        .build();
                //2022-02-11后"广州沃伟科技发展有限公司"不用总经办审核,直接转财务审核
                costDomain.setCostStatus(StringUtils.equals(costDomain.getCompanyNo(),"COM2008121838151") ? CostDomain.STATUS_FINANCIAL_CHECK : CostDomain.STATUS_MANAGER_CHECK);
                costDomain.setLastModifyDate(LocalDateTime.now());
                costDao.updateById(costDomain);
                costLogService.save(costDomain.getCostNo(), currentUserId, "行政审核通过", CostLogDomain.HR_PASS);

                approvalHistoryService.save(approvalHistoryDomain);
                nextState(StringUtils.equals(costDomain.getCompanyNo(),"COM2008121838151") ? financialCheckState: generalManagerCheckState);
                //发布到总线尝试下个环节的自动审核
                costSubscribe.subscribe(costContext);
            }
            //人工审核没权限
            else {
                throw new BizRuntimeException("current user no authority");
            }
        }
    }


    @Override
    public void refuse(String rejectReason) {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;


        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_HR_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }

        //人工审核没权限
        CostCompanyDomain costCompany = costCompanyDao.selectByNo(costDomain.getCompanyNo());
        if (!costCurrentReviewerService.canAudit(currentUserId, costDomain.getCostNo())) {
            throw new BizRuntimeException("current user no authority");
        }


        costLogService.save(costDomain.getCostNo(), currentUserId, "行政审核拒绝,理由:" + rejectReason, CostLogDomain.TYPE_UPDATE);

        //sd
        costContext.costService.reject(costDomain.getCostNo());
        ApprovalHistoryDomain approvalHistoryDomain = ApprovalHistoryDomain.builder()
                .approvalUserId(currentUserId)
                .approvalTime(LocalDateTime.now())
                .costStatus(costDomain.getCostStatus())
                .costNo(costDomain.getCostNo())
                .isPassed(false)
                .build();
        approvalHistoryService.save(approvalHistoryDomain);
    }

    @Override
    public void updateCurrentReviewer() {
        CostDomain costDomain = costContext.costDomain;
        CostTemplate costTemplate = costTemplateService.queryDetail(costDomain.getCostTemplateId());
        CostCompanyDomain costCompanyDomain = costCompanyDao.selectByNo(costDomain.getCompanyNo());

        //如果不需要审核 直接通过
        if (costTemplate.shouldHrCheck(costDomain)) {
            OaUser costUser = oaUserMapper.selectByOaUserId(costDomain.getCreateUserid());

            List<CostReviewer> costReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getReferId, costCompanyDomain.getId())
                    .eq(CostReviewer::getType, CostReviewer.hrReviewer));

            costCurrentReviewerService.updateByCostNoAndReviewer(costDomain.getCostNo(), costReviewerList);
//            costLogService.save(costDomain.getCostNo(), costContext.currentUserId, "行政审核人:" + costReviewerList.stream().map(CostReviewer::getReviewerUserName).collect(Collectors.joining(",")));

        }

    }
}
