package com.blt.other.module.cost.controller;


import com.bailuntec.common.JsonUtilByFsJson;
import com.bailuntec.cost.api.response.CostResult;
import com.blt.other.module.cost.dto.request.AccountingSubjectAddReq;
import com.blt.other.module.cost.dto.request.AccountingSubjectModifyReq;
import com.blt.other.module.cost.model.AccountingSubject;
import com.blt.other.module.cost.service.IAccountingSubjectService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-12-17
 */
@Api(tags = "会计一级科目接口")
@RestController
@RequestMapping("/accountingSubject")
@Slf4j
public class AccountingSubjectController {

    @Resource
    IAccountingSubjectService accountingSubjectService;

    @ApiOperation("新增会计一级科目")
    @PostMapping("/add")
    public CostResult<Void> add(@RequestBody AccountingSubjectAddReq req) {
        log.info("新增会计一级科目:{}", JsonUtilByFsJson.beanToJson(req));
        accountingSubjectService.add(req);
        return CostResult.success();
    }


    @ApiOperation("更新会计一级科目")
    @PostMapping("/modify")
    public CostResult<Void> modify(@RequestBody AccountingSubjectModifyReq req) {
        log.info("新增会计一级科目:{}", JsonUtilByFsJson.beanToJson(req));
        accountingSubjectService.modify(req);
        return CostResult.success();
    }

    @ApiOperation("获取会计一级科目")
    @PostMapping("/queryAll")
    public CostResult<List<AccountingSubject>> queryAll() {
        List<AccountingSubject> list = accountingSubjectService.list();
        return CostResult.success(list);
    }

    @ApiOperation("根据id获取会计一级科目")
    @PostMapping("/queryById")
    public CostResult<AccountingSubject> queryById(@RequestParam Integer id) {
        AccountingSubject accountingSubject = accountingSubjectService.getById(id);
        return CostResult.success(accountingSubject);
    }
}
