package com.blt.other.module.entrepot.controller;

import com.blt.other.common.util.AxiosUtil;
import com.blt.other.module.database.model.StorageDomain;
import com.blt.other.module.entrepot.dto.StorageDto;
import com.blt.other.module.entrepot.service.StorageSearchService;
import com.blt.other.module.entrepot.service.StorageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("storage/list/search")
public class StorageSearchController {

    @Autowired
    private StorageSearchService storageSearchService;

    @Autowired
    private StorageService storageService;

    @PostMapping("")
    public Map<String, Object> doSearch(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();
        String searchKey = request.getParameter("searchKey");
        List<StorageDomain> storages = storageSearchService.getListByKey(searchKey);
        result.put("success", true);
        result.put("storages", storages);

        if (null != storages && storages.size() >= 1) {
            List<StorageDto> storageDtos = new ArrayList<>();
            for (StorageDomain storageDomain : storages) {
                storageDtos.add(storageService.storageDomainToDto(storageDomain));
            }
            result.put("storages", storageDtos);
            result.put("success", true);
            return result;
        }
        result.put("storages", null);
        result.put("success", false);
        return result;
    }


}
