package com.blt.other.module.sku.service.impl;

import com.blt.other.module.database.model.SkuTypeDomain;
import com.blt.other.module.database.model.SupplierDomain;
import com.blt.other.module.database.model.SysProductDomain;
import com.blt.other.module.sku.dao.SkuKindDao;
import com.blt.other.module.sku.dao.SkuTypeDao;
import com.blt.other.module.sku.dao.SysProductDao;
import com.blt.other.module.sku.service.SysProductService;
import com.blt.other.module.supplier.dao.SupplierDao;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class SysProductServiceImpl implements SysProductService {

    @Autowired
    private SysProductDao sysProductDao;

    @Autowired
    private SupplierDao supplierDao;

    @Autowired
    private SkuTypeDao skuTypeDao;

    @Autowired
    private SkuKindDao skuKindDao;

    @Override
    public List<SysProductDomain> getAllSku() {
        return sysProductDao.selectAll();
    }

    @Override
    public Map<String, Object> getAllSkuByPage(Integer pageNum, Integer pageSize) {
        PageHelper.startPage(pageNum,pageSize);
        List<SysProductDomain> sysProductDomains = sysProductDao.selectAll();
        PageInfo<SysProductDomain> pageInfo = new PageInfo<>(sysProductDomains);
        Map<String,Object> map = new HashMap<>();
        map.put("pageInfo",pageInfo);
        map.put("skus",sysProductDomains);
        return map;
    }

    @Override
    public List<SysProductDomain> getSkuByKeyword(String keyword) {
        return sysProductDao.selectByKeyword(keyword);
    }

    @Override
    public SysProductDomain save(SysProductDomain sku) {
        // skucode
        sku.setSkucode(createSkucode());
        // buyUserId buyUserName
        SupplierDomain supplierDomain = supplierDao.selectBySupplierNo(sku.getSupplierNo());
        sku.setBuyuserid(supplierDomain.getBuyuserid());
        sku.setBuyusername(supplierDomain.getBuyusername());
        // suppliername
        sku.setSuppliername(supplierDomain.getName());
        //
        sku.setSupplierid(supplierDomain.getSupplierid());
        sku.setSupplierNo(supplierDomain.getSupplierNo());
        // skuTypeName
        SkuTypeDomain skuTypeDomain = skuTypeDao.selectBySkuTypeNo(sku.getSkuTypeNo());
        sku.setSkuTypeName(skuTypeDomain.getSkuTypeName());
        //  skuKindName
//        SkuKindDomain skuKindDomain = skuKindDao.selectBySkuKindNo(sku.getSkuKindNo());
//        sku.setSkuKindName(skuKindDomain.getSkuKindName());

        Integer result = sysProductDao.insert(sku);
        if (null != result && result >= 1){
            return sku;
        }
        return null;
    }

    @Override
    public SysProductDomain getSkuBySkucode(String skucode) {
        return sysProductDao.selectBySkucode(skucode);
    }

    /**
     * 删除 sku
     * @param skucode
     * @return
     */
    @Override
    public Integer deleteSku(String skucode) {
        return sysProductDao.delete(skucode);
    }

    @Override
    public Integer update(SysProductDomain sysProductDomain) {
        return sysProductDao.update(sysProductDomain);
    }

    /**
     * 生成唯一的 skucode
     * @return
     */
    private String createSkucode(){
        Random random = new Random();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        String skucode = "SKU"+sdf.format(new Date())+random.nextInt(9);
        List<SysProductDomain> sysProductDomains = sysProductDao.selectByKeyword(skucode);
        while (null != sysProductDomains && sysProductDomains.size() >= 1){
            skucode = "SKU"+sdf+random.nextInt(9);
            sysProductDomains = sysProductDao.selectByKeyword(skucode);
        }
        return skucode;
    }
}
