package com.blt.other.module.purchasing.dao;

import com.blt.other.module.database.model.BuyPlanDomain;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface BuyPlanDao {
    /**
     * 查询所有采购计划单
     * @return
     */
    List<BuyPlanDomain> selectAllBuyPlan();

    /**
     * 根据查询条件查询采购计划单 createUsername
     */
    List<BuyPlanDomain> selectBuyPlanByCreateuserName(String createusername);

    /**
     * 根据查询条件查询采购计划单 no
     */
    List<BuyPlanDomain> selectBuyPlanByNo(String no);

    /**
     * insert 采购计划单
     * @param buyPlanDomain
     * @return
     */
    Integer insertNewBuyPlan(BuyPlanDomain buyPlanDomain);

    /**
     * 修改采购计划单
     * @param buyPlanDomain
     * @return
     */
    Integer updateBuyPlan(BuyPlanDomain buyPlanDomain);
}
