package com.blt.other.module.cost.service.impl.costplan;

import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.util.CurUtils;
import com.blt.other.module.cost.service.CostPlanService;
import com.blt.other.module.database.model.CostDomain;
import com.blt.other.module.database.model.CostPlanDomain;
import com.blt.other.module.database.model.CostTypeKindDomain;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;

/**
 * <p>
 * 收款单类型
 * </p>
 *
 * @author robbendev
 * @since 2020/10/16 1:25 下午
 */
@Transactional(rollbackFor = Exception.class)
@Service
public class CostPlanNewReceiptServiceImpl extends AbstractCostPlanService implements CostPlanService {

    @Override
    public void save(CostPlanDomain planDomain) {
        this.doSaveFinansyRecord(planDomain);
        this.completedCostPlan(planDomain);
        planDomain.setCostPlanStatus(0);

        CostTypeKindDomain costTypeKindDomain = costTypeKindDao.selectByKindNo(planDomain.getKindNo());

        planDomain.setKindName(costTypeKindDomain.getKindName());
        planDomain.setTypeNo(costTypeKindDomain.getTypeNo());
        planDomain.setTypeName(costTypeKindDomain.getTypeName());


        costPlanDao.insert(planDomain);
    }

    @Override
    public void update(CostPlanDomain planDomain) {
        this.doSaveFinansyRecord(planDomain);
        this.completedCostPlan(planDomain);

        CostTypeKindDomain costTypeKindDomain = costTypeKindDao.selectByKindNo(planDomain.getKindNo());

        planDomain.setKindName(costTypeKindDomain.getKindName());
        planDomain.setTypeNo(costTypeKindDomain.getTypeNo());
        planDomain.setTypeName(costTypeKindDomain.getTypeName());

        costPlanDao.update(planDomain);
    }

    @Override
    public Integer affirm(String costPlanNo) {
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanNo);
        if (costPlanDomain.getCostPlanStatus() != 0) {
            throw new BizRuntimeException("只能更新待确认的计划单");
        }
        costPlanDomain.setCostPlanStatus(1);
        costPlanDao.update(costPlanDomain);

        CostDomain costDomain = planToCost(costPlanNo);
        String costNo = getCostNo();
        costDomain.setCostNo(costNo);
        costDomain.setCostStatus(0);
        costDomain.setAmount(costPlanDomain.getPlanAmount());
        BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY", getExchangeRateApi);
        costDomain.setToRmbRate(toRmbRate);
        costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
        Integer insert = costDao.insert(costDomain);

        // 记录日志
        costLogService.save(costDomain.getCostNo(), costDomain.getCreateUserid(), "由费用计划：" + costDomain.getCostPlanNo() + " 生成收款单");
        return insert;
    }
}
