package com.blt.other.module.cost.service.impl;

import com.blt.other.module.cost.dao.CostPlanSearchDao;
import com.blt.other.module.cost.dto.CostPlanApiDto;
import com.blt.other.module.cost.service.CostPlanSearchService;
import com.blt.other.module.database.model.CostPlanDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service
public class CostPlanSearchServiceImpl implements CostPlanSearchService {

    @Autowired
    private CostPlanSearchDao costPlanSearchDao;

    @Override
    public CostPlanApiDto.SearchByKeyResp searchByKey(String key) {
        List<CostPlanDomain> costDomainList = costPlanSearchDao.selectByKey(key);
        CostPlanApiDto.SearchByKeyResp resp = new CostPlanApiDto.SearchByKeyResp();
        resp.setList(costDomainList.stream().map(CostPlanDomain::castToDto).collect(Collectors.toList()));
        return resp;
    }
}
