package com.blt.other.module.cost.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.blt.other.module.auth.dto.request.CompanyReviewerListReq;
import com.blt.other.module.database.model.CostCompanyDomain;

import java.util.List;

public interface CostCompanyService extends IService<CostCompanyDomain> {

    /**
     * 从财务系统同步主体
     *
     * @return
     */
    String syncCompany();

    /**
     * 获取所有主体
     *
     * @return
     */
    List<CostCompanyDomain> getAllCompany();


    List<CostCompanyDomain> getAllCompanyAuthority();

    /**
     * 根据 companyNo 获取付款主体
     *
     * @param companyNo
     * @return
     */
    CostCompanyDomain getCompanyByCompanyNo(String companyNo);

    /**
     * <p>
     * 查询财务审核人和最终审核人配置
     * </p>
     *
     * @param req req
     * @return 财务审核人和最终审核人配置
     */
    IPage<CostCompanyDomain> reviewerList(CompanyReviewerListReq req);


    /**
     * <p>
     * 修改最终审核人
     * </p>
     *
     * @param userId              当前用户oa userid
     * @param companyNoList       公司财务主体自编No list
     * @param finalReviewerUserId 最终审核核人oa userid
     */
    void modifyFinalReviewer(Integer userId, List<String> companyNoList, Integer finalReviewerUserId);

    /**
     * <p>
     * 修改财务审核人
     * </p>
     *
     * @param userId                      当前用户oa userid
     * @param companyNoList               公司财务主体自编No list
     * @param financialReviewerUserIdList 财务审核核人oa userid
     */
    void modifyFinancialReviewer(Integer userId, List<String> companyNoList, List<Integer> financialReviewerUserIdList);
}
