package com.blt.other.module.auth.controller;

import com.blt.other.module.auth.service.UserService;
import com.blt.other.module.auth.service.UserSyncService;
import com.blt.other.module.auth.vo.UserAuthMsg;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.util.Collection;
import java.util.List;

@RestController
@RequestMapping(value = "test")
public class UserTestController {

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private UserSyncService userSyncService;

    @Autowired
    private UserService userService;

    /**
     * 获取用户角色信息
     *
     * @return
     */
    @GetMapping("getAuth")
    public List<UserAuthMsg> getAuth() {
        String url = "http://www.bailuntec.com/api/Authorize/UserModuleAuthorize";
        RestTemplate client = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap<String, String> params = new LinkedMultiValueMap<String, String>();
        params.add("UserAccount", "符式酉");
        HttpEntity<MultiValueMap<String, String>> requestEntity = new HttpEntity<MultiValueMap<String, String>>(params, headers);
        ResponseEntity<String> response = client.exchange(url, HttpMethod.POST, requestEntity, String.class);
        String strBody = response.getBody();
        strBody = strBody.replace("\\", "");
        int dataIndex = strBody.indexOf("Data");
        int i = strBody.lastIndexOf("]");
        strBody = strBody.substring(dataIndex + 7, i + 1);

        List<UserAuthMsg> list = null;
        strBody = strBody.toLowerCase();
        ObjectMapper mapper = new ObjectMapper();
        // 使用 ObjectMapper 将 JSON 数据转为 List<BuyUserDomain> 类型
        JavaType javaType = mapper.getTypeFactory().constructParametricType(Collection.class, UserAuthMsg.class);

        try {
            list = mapper.readValue(strBody, javaType);
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return list;
    }
}
