package com.blt.other.module.auth.controller;


import com.bailuntec.cost.api.response.CostResult;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.auth.service.IOaUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-10-12
 */
@Api(tags = "oa用户接接口")
@RestController
@RequestMapping("/oaUser")
public class OaUserController {

    @Autowired
    IOaUserService oaUserService;

    @ApiOperation("/查询oa用户列表和他们的部门管理员")
    @GetMapping("/queryList")
    public CostResult<List<OaUser>> queryList(@RequestParam(required = false) @ApiParam("一级部门id") Integer primaryDepartmentId,
                                              @RequestParam(required = false) @ApiParam("公司id") Integer oaCompanyId) {
        List<OaUser> oaUserList = oaUserService.queryList(primaryDepartmentId, oaCompanyId);
        return CostResult.success(oaUserList);
    }

}
