package com.blt.other.module.database.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel("财务系统用户")
@Data
public class UserDomain {
    private Integer id;

    @ApiModelProperty("用户id")
    private Integer userid;
    @ApiModelProperty("oa用户id")
    private Integer useridsso;
    @ApiModelProperty("用户名")
    private String username;
    @ApiModelProperty("用户帐号")
    private String useraccount;
    @ApiModelProperty("用户编码")
    private String usercode;
    @ApiModelProperty("职位")
    private String jobs;
    @ApiModelProperty("性别")
    private String sex;
    private String rztype;
    @ApiModelProperty("账户状态，正式/试用/实习")
    private String state;

    @ApiModelProperty("部门1")
    private String departmentname1;
    @ApiModelProperty("部门2")
    private String departmentname2;

    @ApiModelProperty("部门全名")
    private String departmentpath;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createtime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastupdatetime;

    private Integer logincount;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date logintime;
    private String logo;
    private String remark;
    private String sign;
    @ApiModelProperty("是否有效，0有效，1失效")
    private Integer isvalid;

    @ApiModelProperty("是否是管理员，0普通用户，1管理员")
    private Integer isadmin; // 是否是管理员，0普通用户，1管理员

    @ApiModelProperty("0 普通用户  1 财务")
    private Integer isfinansys; // 是否是财务  0 不是  1 是

    @ApiModelProperty("审核权限")
    private String authority;
}
