package com.blt.other.module.cost.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.blt.other.module.database.model.CostPlanDomain;
import org.apache.ibatis.annotations.Param;

import java.util.List;


public interface CostPlanDao extends BaseMapper<CostPlanDomain> {


    CostPlanDomain selectByNo(String planNo);

    /**
     * <p>
     * 根据计划单号更新计划单
     * </p>
     *
     * @param costPlanDomain 计划单
     * @return res
     */
    Integer updateByNo(CostPlanDomain costPlanDomain);

    /**
     * <p>
     * 根据计划单号删除计划单
     * </p>
     *
     * @param costPlanNo 计划单号
     * @return res
     */
    Integer deleteByNo(String costPlanNo);

    List<CostPlanDomain> selectAll(@Param("userId") Integer userId);

}
