package com.blt.other.module.purchasing.dao;

import com.blt.other.module.database.model.BuyPlanDetailDomain;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface BuyPlanDetailDao {

    /**
     * 根据采购计划单号获取采购计划单详情
     * @param no
     * @return
     */
    List<BuyPlanDetailDomain> selectBuyPlanDetailByno(String no);

    /**
     * 保存创建的采购计划单中商品详细信息到 detail 表中
     * @param buyPlanDetailDomain 用于从 plan_sku_temp 中获取创建计划单时选择的商品基本信息
     * @return 操作成功的行数
     */
    Integer insertBuyPlanDetail(BuyPlanDetailDomain buyPlanDetailDomain);

    void delete(@Param("no") String no, @Param("skucode") String skucode);

    Integer update(BuyPlanDetailDomain detail);

    BuyPlanDetailDomain selectBuyNoAndSkucode(@Param("no") String no, @Param("skucode") String skucode);
}
