package com.blt.other.other_purchasing.controller;

import com.blt.other.other_commons.utils.AxiosUtil;
import com.blt.other.other_commons.utils.CookieUtil;
import com.blt.other.other_commons.utils.MyMapperUtil;
import com.blt.other.other_database.model.*;
import com.blt.other.other_database.service.PlanNoService;
import com.blt.other.other_entrepot.service.WarehouseService;
import com.blt.other.other_purchasing.dto.SkuForNewPlanSearch;
import com.blt.other.other_purchasing.service.BuyPlanDetailService;
import com.blt.other.other_purchasing.service.BuyPlanService;
import com.blt.other.other_purchasing.service.PlanSkuTempService;
import com.blt.other.other_purchasing.vo.BuyPlanSaveVo;
import com.blt.other.other_sku.service.SysProductService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

@RestController
@RequestMapping("planNew")
public class PurchasingPlanNewController {

    private static Logger logger = LoggerFactory.getLogger(PurchasingPlanNewController.class);


    @Autowired
    private PlanSkuTempService planSkuTempService;
    @Autowired
    private BuyPlanService buyPlanService;
    @Autowired
    private BuyPlanDetailService buyPlanDetailService;
    @Autowired
    private SysProductService sysProductService;
    @Autowired
    private PlanNoService planNoService;
    @Autowired
    private WarehouseService warehouseService;

    private Random random = new Random();

    /**
     * 添加采购计划时 搜索商品 vue
     * @return
     */
    @GetMapping("searchStock")
    public List<SysProductDomain> skuSearchResult(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);

        String keyword = request.getParameter("keyword");
//        List<SkuForNewPlanSearch> skuTempByKeyword = null;
        // 根据查询条件获取 sku
        List<SysProductDomain> skuByKeyword = sysProductService.getSkuByKeyword(keyword);

        return skuByKeyword;
    }

    /**
     * 根据 skucode 获取商品详情
     * @return
     */
    @GetMapping("/selectBySkucode")
    public SysProductDomain selectBySkucode(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);

        String skucode = request.getParameter("skucode");
        // 根据查询条件获取 sku
        SysProductDomain sku = sysProductService.getSkuBySkucode(skucode);

        return sku;
    }

    @PostMapping("/getSkuAmount")
    public Map<String,Object> getSkuAmount(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String skuCountStr = request.getParameter("skuCount");
        String skupriceStr = request.getParameter("skuprice");
        BigDecimal skuCount = new BigDecimal(skuCountStr);
        BigDecimal skuprice = new BigDecimal(skupriceStr);
        BigDecimal skuAmount = skuCount.multiply(skuprice);
        Map<String,Object> result = new HashMap<>();
        result.put("skuAmount",skuAmount);
        result.put("success",true);
        return result;
    }

    @GetMapping("/getPlanNo")
    public String getPlanNo(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String no = "PL"+System.currentTimeMillis()+random.nextInt(100);
        String select = planNoService.select(no);
        while (null != select){
            no = "PL"+System.currentTimeMillis()+random.nextInt(100);
            select = planNoService.select(no);
        }
        planNoService.insert(no);
        return no;
    }

    /**
     * 保存选择的商品列表到 planTemp
     * @param response
     * @param request
     * @return
     */
    @PostMapping("addSkuToPlan")
    public Map<String,Object> addSkuToPlan(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();

        String no = request.getParameter("no");
        String skucode = request.getParameter("skucode");
        String count = request.getParameter("count");

        // 根据 no 和 skucode 查询是否已经存在同一计划单内的相同 sku
        PlanSkuTempDomain tmp = planSkuTempService.getTmpByNoAndSkucode(no,skucode);
        if (null != tmp){
            result.put("success",false);
            result.put("msg","已存在相同商品");
        }
        Integer integer = planSkuTempService.saveToPlanSkuTemp(no, skucode, Integer.parseInt(count));
        if (null != integer && integer == 1){
            result.put("success",true);
        }
        return result;
    }

    /**
     * 保存选择的商品列表到 planTemp
     * @param response
     * @param request
     * @return
     */
//    @Deprecated
//    @PostMapping("saveSkuSelected")
//    public Map<String,String> saveSkuSelected(HttpServletResponse response, HttpServletRequest request){
//        AxiosUtil.setCors(response,request);
//        Map<String,String> result = new HashMap<>();
//
//        Map<String, String[]> parameterMap = request.getParameterMap();
//        Set<String> parameters = parameterMap.keySet();
//        // 采购计划单号
//        String no = request.getParameter("no");
//        if (null == no || !no.contains("PL")){
//            // 生成采购计划单号
//            no = "PL"+System.currentTimeMillis()+random.nextInt(100);
//            logger.warn("生成采购计划单号："+no);
//        }
//
//        for (String str: parameters){
//            if (!"no".equals(str)) {
//                // 执行添加流程
//                String parameter = request.getParameter(str);
//                addSelectToPlan(no, parameter, 1);
//            }
//        }
//        result.put("no",no);
//        result.put("msg","success");
//        return result;
//    }

    /**
     * 创建采购计划单时，获取 plan_temp 中保存的货品信息
     * @param no
     * @param request
     * @param response
     * @return
     */
    @GetMapping("getSkuTemp/{no}")
    public Map<String,Object> getSkuTemp(@PathVariable("no") String no,HttpServletRequest request,HttpServletResponse response){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();
        List<PlanSkuTempDomain> allByNo = planSkuTempService.getAllByNo(no);
        result.put("success",true);
        result.put("tmps",allByNo);
        // 获取采购计划总金额
        if (null != allByNo && allByNo.size() >= 1){
            BigDecimal planAmount = new BigDecimal(0);
            for (PlanSkuTempDomain tmp: allByNo){
                BigDecimal count = new BigDecimal(tmp.getSkucount());
                planAmount = planAmount.add(tmp.getSkuprice().multiply(count));
            }
            result.put("planAmount",planAmount);
        }
        return result;
    }

    @PostMapping("/updateSkuTmp")
    public Map<String,Object> updateSkuTmp(HttpServletRequest request,HttpServletResponse response){
        AxiosUtil.setCors(response,request);
        Enumeration<String> parameterNames = request.getParameterNames();
        if (null != parameterNames && parameterNames.hasMoreElements()){
            String s = parameterNames.nextElement();
            PlanSkuTempDomain object = (PlanSkuTempDomain) MyMapperUtil.getObject(s, PlanSkuTempDomain.class);
            Integer integer = planSkuTempService.resetSkuTemp(object);
            Map<String,Object> result = new HashMap<>();
            result.put("success",true);
            return result;
        }
        return null;
    }

    /**
     * 保存采购计划单
     * @param request
     * @param response
     * @return
     */
    @PostMapping("planSave")
    public Map<String,String> planSave(HttpServletRequest request,HttpServletResponse response){
        AxiosUtil.setCors(response,request);
        Map<String,String> result = new HashMap<>();
        // 获取参数
        // 获取所有参数
        Enumeration<String> params = request.getParameterNames();
        String param =  null;
        if (null != params){
            param =  params.nextElement();
        }else {
            result.put("msg", "数据为空");
            return result;
        }
        BuyPlanSaveVo buyPlanSaveVo = (BuyPlanSaveVo)MyMapperUtil.getObject(param, BuyPlanSaveVo.class);
        // 获取 BLUserAcct
        String blUserAcct = CookieUtil.getBLUserAcct(request);
        buyPlanSaveVo.setBLUserAcct(blUserAcct);
        //  修改 planTem 中的信息
        if (null != buyPlanSaveVo && null != buyPlanSaveVo.getTmps() && buyPlanSaveVo.getTmps().size() >= 1){
            for (PlanSkuTempDomain planSkuTempDomain : buyPlanSaveVo.getTmps()){
                planSkuTempService.resetSkuTemp(planSkuTempDomain);
                logger.warn("planSkuTemp 信息修改:"+planSkuTempDomain.getNo()+"："+planSkuTempDomain.getSkucode());
            }
        }
        if (null == buyPlanSaveVo.getNo() || !buyPlanSaveVo.getNo().contains("PL")){
            result.put("msg","请添加商品");
            result.put("success","warn");
            return result;
        }
        //  执行生成采购计划的流程
        Integer integer = buyPlanService.saveNewBuyPlan(buyPlanSaveVo);
        result.put("msg","保存成功");
        result.put("success","success");
        logger.warn("保存采购计划"+param);

        // TODO 生成buy_plan_detail
        String s = buyPlanDetailService.saveNewBuyPlanDetail(buyPlanSaveVo.getNo(), buyPlanSaveVo.getCompanyName(), buyPlanSaveVo.getDepartmentName(), buyPlanSaveVo.getUsercode());

        return result;
    }

    /**
     * 确认采购计划
     * @param request
     * @param response
     * @return
     */
//    @PostMapping("planAffirm")
//    public Map<String,String> planAffirm(HttpServletRequest request,HttpServletResponse response){
//        AxiosUtil.setCors(response,request);
//        String no = request.getParameter("no");
//        // 生成采购单
//        logger.info("采购计划单："+no+" 已确认");
//        Map<String, String> map = updateBuyPlanStatusMethod(request, 1);
//        String result = buyPlanDetailService.saveNewBuyToBuy(no);
//        map.put("msg",map.get("msg")+"  "+result);
//        return null;
//    }

    /**
     * 提交审核
     * @param request
     * @param response
     * @return
     */
//    @PostMapping("planToAudit")
//    public Map<String,String> planToAudit(HttpServletRequest request,HttpServletResponse response){
//        AxiosUtil.setCors(response,request);
//
//        return  updateBuyPlanStatusMethod(request, 1);
//    }

    /**
     * 审核通过
     * @param request
     * @param response
     * @return
     */
//    @PostMapping("passAudit")
//    public Map<String,String> passAudit(HttpServletRequest request,HttpServletResponse response){
//        AxiosUtil.setCors(response,request);
//        String no = request.getParameter("no");
//        // 生成采购单
//        logger.info("采购计划单："+no+" 审核通过");
//        Map<String, String> map = updateBuyPlanStatusMethod(request, 3);
//        String result = buyPlanDetailService.saveNewBuyToBuy(no);
//        map.put("msg",map.get("msg")+"  "+result);
//        return  map;
//    }

    /**
     * 审核驳回 采购计划作废
     * @param 
     * @param
     * @return
     */
//    @PostMapping("refusePlan")
//    public Map<String,String> refusePlan(HttpServletRequest request,HttpServletResponse response){
//        AxiosUtil.setCors(response,request);
//        String no = request.getParameter("no");
//
//        logger.info("采购计划单："+no+" 被驳回");
//        Map<String, String> map = updateBuyPlanStatusMethod(request, 4);
//        map.put("msg","采购计划已作废");
//        return  map;
//    }

//    private  Map<String,String> updateBuyPlanStatusMethod(HttpServletRequest request,Integer status){
//        Map<String,String> result = new HashMap<>();
//        // 获取参数
//        String no = request.getParameter("no");
//        BuyPlanDomain buyPlanDomain = new BuyPlanDomain();
//        buyPlanDomain.setNo(no);
//        buyPlanDomain.setStatus(status);
//        if (2 == status){
//            buyPlanDomain.setSubmittime(new Date());
//        }else if (3 == status || 4 == status){
//            buyPlanDomain.setAudittime(new Date());
//            String audituserid = request.getParameter("audituserid");
//            String auditusername = request.getParameter("auditusername");
//            buyPlanDomain.setAudituserid(Integer.parseInt(audituserid));
//            buyPlanDomain.setAuditusername(auditusername);
//        }
//        Integer integer = buyPlanService.updateBuyPlan(buyPlanDomain);
//
//        if (null == integer || integer < 1){
//            result.put("success","warn");
//            result.put("msg","操作失败");
//            return result;
//        }
//        result.put("success","success");
//        result.put("msg","操作成功");
//        return result;
//    }

    public String addSelectToPlan(String no,String skucode,Integer skucount){
        String msg = null;
        Integer count = skucount;
            Integer integer = planSkuTempService.saveToPlanSkuTemp(no, skucode, count);
            if (integer != null && integer >= 1){
                msg = no+" 已添加："+skucode+" 数量为："+count;
                logger.warn(msg);
            }
        return msg;
    }

    @PostMapping("/deleteTmp")
    public Map<String,Object> deleteTmp(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String no = request.getParameter("no");
        String skucode = request.getParameter("skucode");
        planSkuTempService.delete(no,skucode);
        List<PlanSkuTempDomain> allByNo = planSkuTempService.getAllByNo(no);
        Map<String,Object> result = new HashMap<>();
        if (null != allByNo && allByNo.size() >= 1){
            BigDecimal planAmount = new BigDecimal(0);
            for (PlanSkuTempDomain tmp: allByNo){
                planAmount = planAmount.add(tmp.getSkuprice().multiply(new BigDecimal(tmp.getSkucount())));
            }
            result.put("tmps",allByNo);
            result.put("planAmount",planAmount);
        }
        return result;
    }
}
