package com.blt.other.other_cost.vo;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;
import java.util.List;

/**
 * 接收前端打印的费用单号列表
 * {"params":{"exportNos":["F000042","F000041-2","SF000040","F000039","F000038","SF000037","F000036","F000035","SF000034","F000033"]}}
 */
public class CostExportVo {
    private ExportNos params;

    public ExportNos getParams() {
        return params;
    }

    public void setParams(ExportNos params) {
        this.params = params;
    }

    @Override
    public String toString() {
        return "CostExportVo{" +
                "params=" + params +
                '}';
    }

    public class ExportNos {
        private List<String> exportNos;
        private Integer userid;
        private String key;
        private Keys keys;

        public List<String> getExportNos() {
            return exportNos;
        }

        public void setExportNos(List<String> exportNos) {
            this.exportNos = exportNos;
        }

        public Integer getUserid() {
            return userid;
        }

        public void setUserid(Integer userid) {
            this.userid = userid;
        }

        public String getKey(){
            return key;
        }

        public void setKey(String key){
            this.key = key;
        }

        public void setKeys(Keys keys){
            this.keys = keys;
        }
        public Keys getKeys(){
            return keys;
        }
        @Override
        public String toString() {
            return "ExportNos{" +
                    "exportNos=" + exportNos +
                    ", userid=" + userid +
                    ", key=" + key +
                    ", keys=" + keys +
                    '}';
        }

        public class Keys{
            private String companyNo;
            private Integer costForm;
            private String createUsercode;
            private String kindNo;
            private Integer costStatus;
            private Integer lendStatus;
            private Integer isTax;
            private Integer isLend;

            @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
            private Date beginTime;
            @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
            private Date endTime;
            @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
            private Date beginPayTime;
            @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
            private Date endPayTime;
            private String linkCost;

            public String getCompanyNo() {
                return companyNo;
            }

            public void setCompanyNo(String companyNo) {
                this.companyNo = companyNo;
            }

            public Integer getCostForm() {
                return costForm;
            }

            public void setCostForm(Integer costForm) {
                this.costForm = costForm;
            }

            public String getCreateUsercode() {
                return createUsercode;
            }

            public void setCreateUsercode(String createUsercode) {
                this.createUsercode = createUsercode;
            }

            public String getKindNo() {
                return kindNo;
            }

            public void setKindNo(String kindNo) {
                this.kindNo = kindNo;
            }

            public Integer getCostStatus() {
                return costStatus;
            }

            public void setCostStatus(Integer costStatus) {
                this.costStatus = costStatus;
            }

            public Integer getIsTax() {
                return isTax;
            }

            public void setIsTax(Integer isTax) {
                this.isTax = isTax;
            }

            public Date getBeginTime() {
                return beginTime;
            }

            public void setBeginTime(Date beginTime) {
                this.beginTime = beginTime;
            }

            public Date getEndTime() {
                return endTime;
            }

            public void setEndTime(Date endTime) {
                this.endTime = endTime;
            }

            public Date getBeginPayTime() {
                return beginPayTime;
            }

            public void setBeginPayTime(Date beginPayTime) {
                this.beginPayTime = beginPayTime;
            }

            public Date getEndPayTime() {
                return endPayTime;
            }

            public void setEndPayime(Date endPayTime) {
                this.endPayTime = endPayTime;
            }

            public Integer getLendStatus() {
                return lendStatus;
            }

            public void setLendStatus(Integer lendStatus) {
                this.lendStatus = lendStatus;
            }

            public Integer getIsLend() {
                return isLend;
            }

            public void setIsLend(Integer isLend) {
                this.isLend = isLend;
            }

            public String getLinkCost() {
                return linkCost;
            }

            public void setLinkCost(String linkCost) {
                this.linkCost = linkCost;
            }

            @Override
            public String toString() {
                return "Keys{" +
                        "companyNo='" + companyNo + '\'' +
                        ", costForm=" + costForm +
                        ", createUsercode='" + createUsercode + '\'' +
                        ", kindNo='" + kindNo + '\'' +
                        ", costStatus=" + costStatus +
                        ", lendStatus=" + lendStatus +
                        ", isTax=" + isTax +
                        ", isLend=" + isLend +
                        ", beginTime=" + beginTime +
                        ", endTime=" + endTime +
                        ", beginPayTime=" + beginPayTime +
                        ", endPayTime=" + endPayTime +
                        ", linkCost='" + linkCost + '\'' +
                        '}';
            }
        }
    }
}
