package com.blt.other.other_cost.service.impl;

import com.blt.other.other_cost.dao.CostPlanDao;
import com.blt.other.other_cost.dao.CostPlanTempDao;
import com.blt.other.other_cost.dao.CostTypeKindDao;
import com.blt.other.other_cost.dto.CostPlanTempDto;
import com.blt.other.other_cost.service.CostPlanTempService;
import com.blt.other.other_database.model.CostPlanDomain;
import com.blt.other.other_database.model.CostPlanTempDomain;
import com.blt.other.other_database.model.CostTypeKindDomain;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;

@Service
public class CostPlanTempServiceImpl implements CostPlanTempService {

    @Autowired
    private CostPlanTempDao costPlanTempDao;

    @Autowired
    private CostTypeKindDao costTypeKindDao;

    @Autowired
    private CostPlanDao costPlanDao;

    @Override
    public String createNo() {

        Random random = new Random();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddhhmmss");
        String no = "CPT"+sdf.format(new Date())+ random.nextInt(9);
        CostPlanTempDomain costPlanTempDomain = costPlanTempDao.selectByNo(no);
        while (null != costPlanTempDomain && null != costPlanTempDomain.getCostPlanNo()){
            no = "CPT"+sdf.format(new Date())+ random.nextInt(9);
            costPlanTempDomain = costPlanTempDao.selectByNo(no);
        }
        return no;
    }

    @Override
    public Integer save(CostPlanTempDomain costPlanTempDomain) {
        Integer insert = costPlanTempDao.insert(costPlanTempDomain);
        if(null != insert && insert == 1){
            // 添加付款子项目成功，计划单改变总额
            CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanTempDomain.getCostPlanNo());
            if(null != costPlanDomain && null != costPlanDomain.getCostPlanNo()){
                if (null == costPlanDomain.getPlanAmount()){
                    costPlanDomain.setPlanAmount(new BigDecimal(0));
                }
                costPlanDomain.setPlanAmount(costPlanDomain.getPlanAmount().add(costPlanTempDomain.getAmount()));
                Integer update  = costPlanDao.update(costPlanDomain);
            }
        }
        return insert;
    }

    @Override
    public CostPlanTempDomain getByPlanNoAndKindNo(String costPlanNo, String kindNo) {
        CostPlanTempDomain costPlanTempDomain = costPlanTempDao.selectByPlanNoAndKindNo(costPlanNo,kindNo);
        if (null == costPlanTempDomain || null == costPlanTempDomain.getTempNo()){
            return null;
        }
        return costPlanTempDomain;
    }

    @Override
    public List<CostPlanTempDto> getTempListByPlanNo(String costPlanNo) {
        List<CostPlanTempDomain> list = costPlanTempDao.selectListByPlanNo(costPlanNo);
        List<CostPlanTempDto> dtoList = null;
        if (null != list && list.size() >= 1){
            dtoList = new ArrayList<>();
            for (CostPlanTempDomain costPlanTempDomain: list){
                dtoList.add(domainToDto(costPlanTempDomain));
            }
        }
        return dtoList;
    }

    @Override
    public Integer deleteItemByPlanNoAndTempNo(String costPlanNo, String tempNo) {
//        CostPlanTempDomain costPlanTempDomain = costPlanTempDao.selectByPlanNoAndKindNo(costPlanNo, kindNo);
        CostPlanTempDomain costPlanTempDomain = costPlanTempDao.selectByPlanNoAndTempNo(costPlanNo,tempNo);
        if (null == costPlanTempDomain || null == costPlanTempDomain.getTempNo()){
            return null;
        }
        Integer result = costPlanTempDao.deletedByPlanNoAndTempNo(costPlanNo,tempNo);
        if (null != result && result >= 0){
            // 删除付款子项目成功，计划单改变总额
            CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanTempDomain.getCostPlanNo());
            if(null != costPlanDomain && null != costPlanDomain.getCostPlanNo()){
                if (null == costPlanDomain.getPlanAmount()){
                    costPlanDomain.setPlanAmount(new BigDecimal(0));
                }
                costPlanDomain.setPlanAmount(costPlanDomain.getPlanAmount().subtract(costPlanTempDomain.getAmount()));
                Integer update  = costPlanDao.update(costPlanDomain);
            }
            return result;
        }
        return null;
    }

    @Override
    public CostPlanTempDomain getByTempNo(String tempNo) {
        CostPlanTempDomain costPlanTempDomain = costPlanTempDao.selectByNo(tempNo);
        if (null != costPlanTempDomain && null != costPlanTempDomain.getId()){
            return costPlanTempDomain;
        }
        return null;
    }

    @Override
    public Integer update(CostPlanTempDomain domain) {
        Integer update = costPlanTempDao.update(domain);
        return update;
    }

    @Override
    public void deleteFilePath(String tempNo) {
        costPlanTempDao.deletedFilePath(tempNo);
    }

    @Override
    public List<CostPlanTempDomain> getListByPlanNoAndTypeNo(String costPlanNo, String typeNo) {
        return costPlanTempDao.selectByPlanNoAndTypeNo(costPlanNo,typeNo);
    }

    @Override
    public CostPlanTempDomain getByPlanNoAndTempNo(String costPlanNo, String tempNo) {
        return costPlanTempDao.selectByPlanNoAndTempNo(costPlanNo,tempNo);
    }

    private CostPlanTempDto domainToDto(CostPlanTempDomain costPlanTempDomain){
        CostPlanTempDto dto = new CostPlanTempDto();
        BeanUtils.copyProperties(costPlanTempDomain,dto);

        CostTypeKindDomain costTypeKindDomain = costTypeKindDao.selectByKindNo(costPlanTempDomain.getKindNo());
        if (null != costTypeKindDomain) {
            dto.setTypeNameDto(costTypeKindDomain.getTypeName());
            dto.setKindNameDto(costTypeKindDomain.getKindName());
        }

        String filePath = costPlanTempDomain.getFilePath();
        if (null != filePath){
            String[] split = filePath.split("&");
            if (null != split && split.length >= 1){
                dto.setFileName(split[1]);
            }
        }

        return dto;
    }
}
