package com.blt.other.other_purchasing.controller;

import com.blt.other.other_commons.utils.AxiosUtil;
import com.blt.other.other_commons.utils.MyMapperUtil;
import com.blt.other.other_database.model.BuyDomain;
import com.blt.other.other_purchasing.dto.BuyListDto;
import com.blt.other.other_purchasing.service.BuySearchService;
import com.blt.other.other_purchasing.service.BuyService;
import com.blt.other.other_purchasing.vo.PurcharseListSearchKeysVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("purchasing/list/search")
public class PurchasingListSearchController {

    @Autowired
    private BuySearchService buySearchService;
    @Autowired
    private BuyService buyService;

    @PostMapping("")
    public Map<String,Object> doSearch(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String searchKey = request.getParameter("searchKey");
        String pageNumStr = request.getParameter("pageNum");
        String pageSizeStr = request.getParameter("pageSize");
        Map<String,Object> result = buySearchService.searchByKey(searchKey,Integer.parseInt(pageNumStr),Integer.parseInt(pageSizeStr));

        result.put("success",true);
        return result;
    }

    @PostMapping("/keys")
    public Map<String,Object> keys(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Enumeration<String> parameterNames = request.getParameterNames();
        if (null != parameterNames && parameterNames.hasMoreElements()){
            String s = parameterNames.nextElement();
            PurcharseListSearchKeysVo object = (PurcharseListSearchKeysVo)MyMapperUtil.getObject(s, PurcharseListSearchKeysVo.class);
            Map<String,Object> result = buySearchService.searchByKeys(object);
            result.put("success",true);
            return result;
        }
        return null;
    }
}
