package com.blt.other.other_cost.service.impl;

import com.blt.other.other_cost.dto.CostCompanyFinansysDto;
import com.blt.other.other_cost.service.CostCompanyFinansysService;
import com.blt.other.other_cost.vo.CostCompanyDataVo;
import com.blt.other.other_cost.vo.CostCompanyVo;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Service
public class CostCompanyFinansysServiceImpl implements CostCompanyFinansysService {

    @Value("${url.api.postCompanyListFinansysApi}")
    private String postCompanyListFinansysApi;

    @Override
    public CostCompanyVo getCostCompanyVo(Integer mValue){
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap<String, String> params= new LinkedMultiValueMap<String, String>();
        params.add("mValue",mValue+"");
        HttpEntity<MultiValueMap<String, String>> requestEntity = new HttpEntity<MultiValueMap<String, String>>(params, headers);
        ResponseEntity<String> response = restTemplate.exchange(postCompanyListFinansysApi, HttpMethod.POST, requestEntity, String.class);

        ObjectMapper mapper = new ObjectMapper();
        String strBody = null;
        if (response != null && response.getStatusCodeValue() == 200) {
            strBody = response.getBody();
        }

        CostCompanyVo costCompanyVo = null;
        try {
            strBody = strBody.toLowerCase();
            costCompanyVo = mapper.readValue(strBody,CostCompanyVo.class);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return costCompanyVo;
    }

    @Override
    public List<CostCompanyFinansysDto> getCostCompanyFinansysDto(CostCompanyVo costCompanyVo) {
        if (null != costCompanyVo){
            List<CostCompanyDataVo> data = costCompanyVo.getData();
            if (null != data && data.size() >= 1){
                List<CostCompanyFinansysDto> list = new ArrayList<>();
                CostCompanyFinansysDto costCompanyFinansysDto = null;
                for (CostCompanyDataVo costCompanyDataVo : data){
                    costCompanyFinansysDto = new CostCompanyFinansysDto();
                    costCompanyFinansysDto.setId(costCompanyDataVo.getId());
                    costCompanyFinansysDto.setBankName(costCompanyDataVo.getBankname());
                    costCompanyFinansysDto.setBankCard(costCompanyDataVo.getBankcard());
                    costCompanyFinansysDto.setBankCardUser(costCompanyDataVo.getBankcarduser());
                    costCompanyFinansysDto.setMainBodyName(costCompanyDataVo.getMainbodyname());
                    costCompanyFinansysDto.setMainBodyValue(costCompanyDataVo.getMainbodyvalue());
                    list.add(costCompanyFinansysDto);
                }
                return list;
            }
        }
        return null;
    }
}
