package com.blt.other.module.sys.controller;


import com.bailuntec.cost.api.response.CostResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.module.sys.model.UserRoleBinding;
import com.blt.other.module.sys.service.IUserRoleBindingService;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Collection;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2021-03-10
 */
@ApiOperation("用户角色绑定关系接口")
@RestController
@RequestMapping("/userRoleBinding")
public class UserRoleBindingController {

    @Resource
    IUserRoleBindingService userRoleBindingService;

    @ApiOperation("新增用户角色绑定关系")
    @PostMapping("/save")
    public CostResult<Void> save(@RequestBody UserRoleBinding userRoleBinding) {
        userRoleBindingService.save(userRoleBinding);
        return CostResult.success();
    }

    @ApiOperation("批量新增用户角色绑定关系")
    @PostMapping("/save")
    public CostResult<Void> save(@RequestBody Collection<UserRoleBinding> collection) {
        userRoleBindingService.saveBatch(collection);
        return CostResult.success();
    }


    @ApiOperation("分页查询用户角色绑定关系")
    @PostMapping("/page")
    public CostResult<Page<UserRoleBinding>> page(@RequestBody Page<UserRoleBinding> page) {
        return CostResult.success(userRoleBindingService.page(page));
    }

    @ApiOperation("删除用户角色绑定关系")
    @GetMapping("/removeById")
    public CostResult<Void> remove(@RequestParam Integer id) {
        userRoleBindingService.removeById(id);
        return CostResult.success();
    }

    @ApiOperation("更新用户角色绑定关系")
    @PostMapping("/updateById")
    public CostResult<Void> updateById(@RequestBody UserRoleBinding userRoleBinding) {
        userRoleBindingService.updateById(userRoleBinding);
        return CostResult.success();
    }

}
