package com.blt.other.module.sys.controller;


import com.bailuntec.cost.api.response.CostResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.module.sys.model.Role;
import com.blt.other.module.sys.model.RoleCostCompanyBinding;
import com.blt.other.module.sys.service.IRoleCostCompanyBindingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Collection;

/**
 * <p>
 * 角色和主体权限绑定关系 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2021-03-10
 */
@Api(tags = "角色和主体权限绑定关系接口")
@RestController
@RequestMapping("/roleCostCompanyBinding")
public class RoleCostCompanyBindingController {

    @Resource
    IRoleCostCompanyBindingService roleCostCompanyBindingService;

    @ApiOperation("新增角色和主体权限绑定")
    @PostMapping("/save")
    public CostResult<Void> save(@RequestBody RoleCostCompanyBinding roleCostCompanyBinding) {
        roleCostCompanyBindingService.save(roleCostCompanyBinding);
        return CostResult.success();
    }

    @ApiOperation("批量新增角色和主体权限绑定")
    @PostMapping("/saveBatch")
    public CostResult<Void> saveBatch(@RequestBody Collection<RoleCostCompanyBinding> collection) {
        roleCostCompanyBindingService.saveBatch(collection);
        return CostResult.success();
    }


    @ApiOperation("分页查询角色和主体权限绑定")
    @PostMapping("/page")
    public CostResult<Page<RoleCostCompanyBinding>> page(@RequestBody Page<RoleCostCompanyBinding> page) {
        return CostResult.success(roleCostCompanyBindingService.page(page));
    }

    @ApiOperation("删除角色和主体权限绑定")
    @GetMapping("/removeById")
    public CostResult<Void> remove(@RequestParam Integer id) {
        roleCostCompanyBindingService.removeById(id);
        return CostResult.success();
    }

    @ApiOperation("更新角色和主体权限绑定")
    @PostMapping("/updateById")
    public CostResult<Void> updateById(@RequestBody RoleCostCompanyBinding roleCostCompanyBinding) {
        roleCostCompanyBindingService.updateById(roleCostCompanyBinding);
        return CostResult.success();
    }

}
