package com.blt.other.module.log.service.impl;

import com.blt.other.module.log.dao.OperationLogDao;
import com.blt.other.module.log.model.OperationLog;
import com.blt.other.module.log.service.OperationLogService;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
@Service
@Transactional
public class OperationLogServiceImpl implements OperationLogService {

    @Resource
    private OperationLogDao operationLogDao;

    @Override
    @Async
    public void insert(OperationLog log) {
        log.setCreateTime(LocalDateTime.now());
        operationLogDao.insert(log);
    }
}
