package com.blt.other.module.cost.service.impl;

import com.blt.other.module.cost.dao.CostTypeKindDao;
import com.blt.other.module.cost.dao.LogisticsSupplierBankDao;
import com.blt.other.module.cost.service.CostTypeKindService;
import com.blt.other.module.database.model.CostTypeKindDomain;
import com.blt.other.module.database.model.LogisticsSupplierBankDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CostTypeKindServiceImpl implements CostTypeKindService {
    @Autowired
    private CostTypeKindDao costTypeKindDao;
    @Autowired
    private LogisticsSupplierBankDao logisticsSupplierBankDao;

    @Override
    public CostTypeKindDomain getKindByKindNo(String kindNo) {
        return costTypeKindDao.selectByKindNo(kindNo);
    }

    @Override
    public LogisticsSupplierBankDomain getLogisticsBank(String subSupplierName) {
        return logisticsSupplierBankDao.selectBySubSupplier(subSupplierName);
    }
}
