package com.blt.other;

import com.blt.other.common.util.AxiosUtil;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@RestController
@SpringBootApplication(scanBasePackages = {"com.blt.other", "com.bailuntec"})
@EnableFeignClients
@MapperScan(basePackages = "com.blt.other.module.*.dao")
public class OtherApplication {

    public static void main(String[] args) {
        SpringApplication.run(OtherApplication.class, args);
    }

    @GetMapping("/application")
    public String application(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        return "其他采购  费用系统";
    }
}
