package com.blt.other.sku.controller;

import com.blt.other.commons.utils.AxiosUtil;
import com.blt.other.database.model.SkuTypeDomain;
import com.blt.other.sku.service.SkuTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("sku/type/")
public class SkuTypeController {

    private static Logger logger = LoggerFactory.getLogger(SkuTypeController.class);

    @Autowired
    private SkuTypeService skuTypeService;

    @GetMapping("getTypeList")
    public Map<String,Object> getTypeList(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();
        List<SkuTypeDomain> skuTypeList =  skuTypeService.getAllTypes();

        result.put("success",true);
        result.put("skuTypes",skuTypeList);
        return result;
    }

    @PostMapping("/add/save")
    public Map<String, Object> save(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();

        String skuTypeName = request.getParameter("skuTypeName");
        // 判断 skuTypeName 是否已经存在
        List<SkuTypeDomain> listBySkuTypeName = skuTypeService.getListBySkuTypeName(skuTypeName);
        if (null != listBySkuTypeName && listBySkuTypeName.size() >= 1){
            result.put("success",false);
            result.put("msg",skuTypeName+" 已存在");
            return result;
        }
        String createUserId = request.getParameter("createUserId");
        SkuTypeDomain skuTypeDomain = new SkuTypeDomain();

        skuTypeDomain.setSkuTypeName(skuTypeName);
        try {
            skuTypeDomain.setCreateUserId(Integer.parseInt(createUserId));
        }catch (NumberFormatException e){
            result.put("success",false);
            result.put("msg","请登陆");
            return result;
        }
        skuTypeDomain.setCreateTime(new Date());
        Integer integer = skuTypeService.saveSkuType(skuTypeDomain);

        result.put("success",true);
        result.put("skuType",skuTypeDomain);
        return result;
    }
}
