package com.blt.other.sku.controller;

import com.blt.other.commons.utils.AxiosUtil;
import com.blt.other.database.model.SysProductDomain;
import com.blt.other.sku.service.SkuSerchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("sku/search")
public class SkuSearchController {

    @Autowired
    private SkuSerchService skuSerchService;

    @PostMapping("")
    public Map<String,Object> key(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();
        String searchKey = request.getParameter("searchKey");
        List<SysProductDomain> skus = skuSerchService.getByKey(searchKey);
        result.put("success",true);
        result.put("skus",skus);
        return result;
    }

    @GetMapping("/getSkuDetail")
    public Map<String,Object> getSkuDetail(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String skucode = request.getParameter("skucode");
        SysProductDomain sku = skuSerchService.getBySkucode(skucode);
        Map<String,Object> result = new HashMap<>();
        result.put("sku",sku);
        result.put("success",true);
        return result;
    }
}
