package com.blt.other.cost.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bailuntec.common.JsonUtilByFsJson;
import com.bailuntec.cost.api.dto.LogisticsFinansysDto;
import com.bailuntec.cost.api.dto.SubLogisticsFinansysDto;
import com.blt.other.auth.dao.UserDao;
import com.blt.other.commons.utils.MyMapperUtil;
import com.blt.other.cost.dao.UserCostFinansysDao;
import com.blt.other.cost.service.UserCostFinansysService;
import com.blt.other.cost.vo.UserCostFinansysVo;
import com.blt.other.cost.vo.UserFinansysVo;
import com.blt.other.database.model.CostDomain;
import com.blt.other.database.model.CostPlanDomain;
import com.blt.other.database.model.UserCostFinansysDomain;
import com.blt.other.database.model.UserDomain;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Service
public class UserCostFinansysServiceImpl implements UserCostFinansysService {

    @Autowired
    private UserCostFinansysDao userCostFinansysDao;

    @Autowired
    private UserDao userDao;
    @Value("${url.api.getSupplierPageListApi}")
    private String getSupplierPageListApi;

    @Value("${url.api.getAllLogisticsFinansysApi}")
    private String getAllLogisticsFinansysApi;

    @Value("${url.api.getAllSubLogisticsFinansysApi}")
    private String getAllSubLogisticsFinansysApi;

    @Override
    public Integer saveFinansysRecord(UserCostFinansysDomain userCostFinansysDomain) {
        UserCostFinansysDomain byUserCostFinansysDetail = getByUserCostFinansysDetail(userCostFinansysDomain);
        if (null != byUserCostFinansysDetail && null != byUserCostFinansysDetail.getUserCostFinansysNo()) {
            return null;
        }
        return userCostFinansysDao.insert(userCostFinansysDomain);
    }

    @Override
    public UserCostFinansysDomain createFinansyRecordByCostPlanDomain(CostPlanDomain planDomain) {
        CostDomain costDomain = new CostDomain();
        BeanUtils.copyProperties(planDomain, costDomain);
        return setParams(costDomain);
    }

    @Override
    public UserCostFinansysDomain createFinansyRecordByCostDomain(CostDomain costDomain) {
        return setParams(costDomain);
    }

    private UserCostFinansysDomain setParams(CostDomain cost) {
        UserCostFinansysDomain userCostFinansysDomain = new UserCostFinansysDomain();
        UserDomain user = userDao.select(cost.getCreateUsercode());
        userCostFinansysDomain.setUsercode(user.getUsercode());
        userCostFinansysDomain.setUseraccount(user.getUseraccount());
        userCostFinansysDomain.setUsername(user.getUsername());
        userCostFinansysDomain.setUserid(user.getUserid());
        userCostFinansysDomain.setBankName(cost.getBankName());
        userCostFinansysDomain.setBankCard(cost.getBankCard());
        userCostFinansysDomain.setBankCardUser(cost.getBankCardUser());
        userCostFinansysDomain.setBankCompany(cost.getBankCompany());
        userCostFinansysDomain.setUserCostFinansysNo(createNo());
        return userCostFinansysDomain;
    }

    @Override
    public List<UserCostFinansysDomain> getByUsercode(String usercode) {
        return userCostFinansysDao.selectByUsercode(usercode);
    }

    @Override
    public UserCostFinansysDomain getByUserCostFinansysNo(String userCostFinansysNo) {
        return userCostFinansysDao.selectByNo(userCostFinansysNo);
    }

    @Override
    public UserCostFinansysDomain getByUserCostFinansysDetail(UserCostFinansysDomain userCostFinansysDomain) {
        return userCostFinansysDao.selectByDetail(userCostFinansysDomain);
    }

    @Override
    public List<UserCostFinansysDomain> getAllFinansysRecord() {
        List<UserCostFinansysDomain> list = userCostFinansysDao.selectAll();
        return list;
    }

    /**
     * 同步财务信息
     *
     * @return
     */
    @Override
    public String syncUserFinansys() {
        // 1、获取 page=1  pagesize=25 ，并得到总条数
        UserFinansysVo userFinansysVo = getUserFinansysVo(1, 25);
        Integer total = userFinansysVo.getTotal();
        // 2、 获取总页数
        int result = 0;
        int update = 0;
        if (null != total && total >= 1) {
            int pageNum = 1;
            for (pageNum = 1; pageNum <= ((total / 25) + 1); pageNum++) {
                List<UserCostFinansysVo> vos = getUserCostFinansysList(pageNum, 25);
                if (null != vos && vos.size() >= 1) {
                    for (UserCostFinansysVo vo : vos) {
                        if (3 == vo.getStatus() && 13 == vo.getCategoryid()) {
                            Integer insert = insertUserFinansys(vo);
                            if (null != insert && 1 == insert)
                                result += 1;
                            if (null != insert && 0 == insert)
                                update += 1;
                        }
                    }
                }
            }
        }
        return "新增 " + result + " 条记录，新增 " + update + " 条记录";
    }

    /**
     * 根据 userid 获取财务信息
     *
     * @param
     * @return
     */
    @Override
    public List<UserCostFinansysDomain> getByUserid(int userid) {
        return userCostFinansysDao.selectByUserid(userid);
    }

    /**
     * 保存/修改从财务系统获取的财务信息
     *
     * @param vo
     * @return
     */
    private Integer insertUserFinansys(UserCostFinansysVo vo) {
        UserCostFinansysDomain userCostFinansysDomain = userCostFinansysDao.selectByBankInfo(vo.getBankname(), vo.getCardno(), vo.getCardusername(), vo.getCardusername());
        UserCostFinansysDomain domain = new UserCostFinansysDomain();
        domain.setSyncId(vo.getId());
        domain.setUserid(vo.getCreateuserid());
        domain.setUsername(vo.getCreateusername());
        domain.setUseraccount(vo.getUsername());
        domain.setBankName(vo.getBankname());
        domain.setBankCardUser(vo.getCardusername());
        domain.setBankCard(vo.getCardno());
        domain.setBankCompany(vo.getCardusername());
        domain.setUserCostFinansysNo(createNo());
        if (null == userCostFinansysDomain) {
            // 没有该记录，添加
            Integer insert = userCostFinansysDao.insert(domain);
            if (null != insert && 1 == insert)
                return 1;
            else
                return null;
        } else {
            Integer update = userCostFinansysDao.updateBySyncId(domain);
            if (null != update && 1 == update)
                return 0;
            else
                return null;
        }
    }

    private List<UserCostFinansysVo> getUserCostFinansysList(Integer pageNum, Integer pageSize) {
        RestTemplate restTemplate = new RestTemplate();
        String url = getSupplierPageListApi + "?page=" + pageNum + "&pagesize=" + pageSize + "&key";
        ResponseEntity<String> response = restTemplate.getForEntity(url, String.class);
        if (response.getStatusCodeValue() == 200) {
            String strBody = response.getBody();
            JSONObject jsonObject = JSON.parseObject(strBody);
            String resultStr = String.valueOf(jsonObject.get("list"));
            return JsonUtilByFsJson.jsonToList(resultStr, UserCostFinansysVo.class);
        }
        return null;
    }

    private UserFinansysVo getUserFinansysVo(Integer pageNum, Integer pageSize) {
        RestTemplate restTemplate = new RestTemplate();
        String url = getSupplierPageListApi + "?page=" + pageNum + "&pagesize=" + pageSize + "&key";
        ResponseEntity<String> response = restTemplate.getForEntity(url, String.class);

        String strBody = null;
        if (response.getStatusCodeValue() == 200) {
            strBody = response.getBody();
            UserFinansysVo object = (UserFinansysVo) MyMapperUtil.getObject(strBody, UserFinansysVo.class);
            return object;
        }
        return null;
    }

    private String createNo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        String no = "UCF" + sdf.format(new Date());

        UserCostFinansysDomain userCostFinansysDomain = userCostFinansysDao.selectByNo(no);
        while (null != userCostFinansysDomain && null != userCostFinansysDomain.getUserCostFinansysNo()) {
            no = "UCF" + sdf.format(new Date());
            userCostFinansysDomain = userCostFinansysDao.selectByNo(no);
        }
        return no;
    }

    @Override
    public List<LogisticsFinansysDto> getAllLogisticsFinansys() {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity<String> response = restTemplate.getForEntity(getAllLogisticsFinansysApi, String.class);
        String strBody = null;
        if (response != null && response.getStatusCodeValue() == 200) {
            strBody = response.getBody();
            List<LogisticsFinansysDto> logistics = JSONObject.parseArray(strBody, LogisticsFinansysDto.class);
            return logistics;
        }
        return null;
    }

    @Override
    public List<SubLogisticsFinansysDto> getAllSubLogisticsFinansys() {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity<String> response = restTemplate.getForEntity(getAllSubLogisticsFinansysApi, String.class);
        String strBody = null;
        if (response != null && response.getStatusCodeValue() == 200) {
            strBody = response.getBody();
            List<SubLogisticsFinansysDto> subLogistics = JSONObject.parseArray(strBody, SubLogisticsFinansysDto.class);
            return subLogistics;
        }
        return null;
    }

}
