package com.blt.other.cost.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 费用单基础字段
 * </p>
 *
 * @author robbendev
 * @since 2020-10-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CostTemplateBaseCol对象", description = "费用单基础字段")
public class CostTemplateBaseCol implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "对应cost表字段名")
    private String costCol;

    @ApiModelProperty(value = "对应cost表字段数据库类型")
    private String costColType;

    @ApiModelProperty(value = "表单字段名")
    private String colName;

    @ApiModelProperty(value = "1-单行文本 2-多行文本 3-下拉框 4-多选 5-日期 6-附件")
    private Integer colType;

    @ApiModelProperty(value = "表单字段数据来源 1. input 人工输入 2. api 网络请求 3. enum 枚举")
    private Integer colDateSource;

    @ApiModelProperty(value = "如果字段数据来源是api网络请求(colDateSource = 2) 这里记获取可选值的api全链接。")
    private String colApi;

    @ApiModelProperty(value = "如果费用单字段记录是enum枚举(colDateSource = 3),这里可选的枚举值，用逗号分隔。")
    private String colEnum;

    @ApiModelProperty("是否扩展字段")
    private Boolean isExtension;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime lastUpdateTime;


}
