package com.blt.other.auth.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.blt.other.auth.dto.request.CompanyReviewerListReq;
import com.blt.other.auth.model.OaCompany;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-12
 */
public interface IOaCompanyService extends IService<OaCompany> {

    /**
     * <p>
     * 获取百伦公司主体
     * </p>
     *
     * @return 百伦公司主体
     */
    List<OaCompany> oaCompanyList();

    /**
     * <p>
     * 查询财务审核人和最终审核人配置
     * </p>
     *
     * @param req req
     * @return 财务审核人和最终审核人配置
     */
    IPage<OaCompany> reviewerList(CompanyReviewerListReq req);

    /**
     * <p>
     * 修改最终审核人
     * </p>
     *
     * @param userId              当前用户oa userid
     * @param oaCompanyId         oa公司主体id
     * @param finalReviewerUserId 最终审核核人oa userid
     */
    void modifyFinalReviewer(Integer userId, Integer oaCompanyId, Integer finalReviewerUserId);

    /**
     * <p>
     * 修改财务审核人
     * </p>
     *
     * @param userId                  当前用户oa userid
     * @param oaCompanyId             oa公司主体id
     * @param financialReviewerUserIds 财务审核核人oa userid
     */
    void modifyFinancialReviewer(Integer userId, Integer oaCompanyId, List<Integer> financialReviewerUserIds);
}
