package com.blt.other.module.netsuite.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in  2021-04-28
 * @Modified by:
 */
@ApiModel("Netsuite日志")
@TableName(value = "netsuite_log", autoResultMap = true)
@Data
public class NetsuiteLogDomain implements Serializable {

    /**
     * 未推送
     */
    public final static Integer UNPUBLISH = 0;

    /**
     * 已推送
     */
    public final static Integer PUBLISHED = 1;

    /**
     * 推送失败
     */
    public final static Integer FAILURE = 99;

    /**
     * netsuite 传输类型；78：费用单
     */
    public final static Integer SCRIPT_FEE = 78;

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("费用单号")
    private String costNo;

    @ApiModelProperty("json参数")
    private String jsonStr;

    @ApiModelProperty("脚本ID，78：费用单")
    private Integer script;

    @ApiModelProperty("请求异常信息")
    private String errorMsg;

    @ApiModelProperty("推送状态，0：未推送，1：已推送，99：推送失败")
    private Integer publishStatus;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("最后更新时间")
    private LocalDateTime createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("最后更新时间")
    private LocalDateTime lastModifyTime;
}
