package com.blt.other.module.cost.controller;

import com.bailuntec.cost.api.response.CostResult;
import com.blt.other.module.cost.service.CostCompanyService;
import com.blt.other.module.database.model.CostCompanyDomain;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/12/17 1:22 下午
 */
@Api(tags = "财务主体接口")
@RestController
public class CostCompanyController {

    @Resource
    CostCompanyService costCompanyService;

    @ApiOperation("查询所有财务付款主体")
    @GetMapping("/cost/type/getAllCompany")
    public List<CostCompanyDomain> getAllCompany() {
        return costCompanyService.getAllCompany();
    }

    @ApiOperation("获取所有财务付款主体权限？")
    @GetMapping("/cost/type/getAllCompanyAuthority")
    public List<CostCompanyDomain> getAllCompanyAuthority() {
        return costCompanyService.getAllCompanyAuthority();
    }

    @ApiOperation("同步财务付款主体")
    @GetMapping("/cost/type/syncAllCompany")
    public CostResult<Void> syncAllCompany() {
        costCompanyService.syncCompany();
        return CostResult.success();
    }

}
