package com.blt.other.module.cost.service.impl.costcheck;

import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.module.auth.dao.OaDepartmentMapper;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.CostReviewer;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.model.CostTemplate;
import com.blt.other.module.database.model.CostCompanyDomain;
import com.blt.other.module.database.model.CostLogDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/30 2:57 下午
 */
@Component
public class HrCheckState extends CostState {

    @Autowired
    FinancialCheckState financialCheckState;
    @Resource
    OaDepartmentMapper oaDepartmentMapper;
    @Resource
    OaUserMapper oaUserMapper;
    @Resource
    CostCompanyDao costCompanyDao;

    @Override
    public void handle() {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;
        CostTemplate costTemplate = costTemplateService.queryDetail(costDomain.getCostTemplateId());

        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_HR_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }

        //如果不需要审核 直接通过
        if (!costTemplate.shouldHrCheck(costDomain)) {

            costDomain.setCostStatus(CostDomain.STATUS_FINANCIAL_CHECK);
            costDao.updateById(costDomain);

            //流转状态
            nextState(financialCheckState);
            costSubscribe.subscribe(costContext);
//            costLogService.saveByManage(costDomain.getCostNo(), "行政审核自动通过", CostLogDomain.DEPARTMENT_AUTO_PASS);

            return;
        }

        //人工审核
        CostCompanyDomain costCompany = costCompanyDao.selectByNo(costDomain.getCompanyNo());
        if (costContext.currentUserId != null) {
            //人工审核通过
            if (costReviewerMapper.queryOne(costCompany.getId(), CostReviewer.hrReviewer, currentUserId) != null) {
                costDomain.setCostStatus(CostDomain.STATUS_FINANCIAL_CHECK);
                costDao.updateById(costDomain);
                costLogService.save(costDomain.getCostNo(), currentUserId, "行政审核通过", CostLogDomain.HR_PASS);

                nextState(financialCheckState);
                //发布到总线尝试下个环节的自动审核
                costSubscribe.subscribe(costContext);
            }
            //人工审核没权限
            else {
                throw new BizRuntimeException("current user no authority");
            }
        }
    }


    @Override
    public void refuse(String rejectReason) {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;

        OaUser costUser = oaUserMapper.selectByOaUserId(costDomain.getCreateUserid());


        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_HR_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }

        //人工审核没权限
        CostCompanyDomain costCompany = costCompanyDao.selectByNo(costDomain.getCompanyNo());
        if (costReviewerMapper.queryOne(costCompany.getId(), CostReviewer.hrReviewer, currentUserId) == null) {
            throw new BizRuntimeException("current user no authority");
        }


        costLogService.save(costDomain.getCostNo(), currentUserId, "行政审核拒绝,理由:" + rejectReason, CostLogDomain.TYPE_UPDATE);

        //sd
        costContext.costService.reject(costDomain.getCostNo());

    }
}
