package com.blt.other.module.cost.controller;


import com.bailuntec.cost.api.response.CostResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.module.cost.dto.request.*;
import com.blt.other.module.cost.model.SpecDepartmentCheckConfig;
import com.blt.other.module.cost.service.ISpecDepartmentCheckConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-12-16
 */
@Api(tags = "特殊审核人")
@RestController
@RequestMapping("/specDepartmentCheckConfig")
public class SpecDepartmentCheckConfigController {


    @Resource
    ISpecDepartmentCheckConfigService specDepartmentCheckConfigService;


    @ApiOperation("分页查询特殊审核人")
    @PostMapping("/queryPage")
    public CostResult<Page<SpecDepartmentCheckConfig>> queryPage(@RequestBody SpecDepartmentCheckQueryPageReq req) {
        Page<SpecDepartmentCheckConfig> page = specDepartmentCheckConfigService.queryPage(req);
        return CostResult.success(page);
    }

    @ApiOperation("批量设置特殊审核人")
    @PostMapping("/batchUpdateReviewer")
    public CostResult<Void> batchUpdateReviewer(@RequestBody BatchUpdateReviewerReq req) {
        specDepartmentCheckConfigService.batchUpdateReviewer(req);
        return CostResult.success();
    }

    @ApiOperation("新增特殊审核数据")
    @PostMapping("/add")
    public CostResult<Void> add(@RequestBody SpecDepartmentCheckAddReq req) {
        specDepartmentCheckConfigService.add(req);
        return CostResult.success();
    }

    @ApiOperation("批量导入数据")
    @PostMapping("/importExcel")
    public CostResult<Void> importExcel(SpecDepartmentCheckImportExcelReq excel) throws IOException {
        specDepartmentCheckConfigService.importExcel(excel);
        return CostResult.success();
    }

    @ApiOperation("导出excel")
    @PostMapping("/importExcel")
    public CostResult<Void> exportExcel(HttpServletResponse response,
                                        @RequestBody SpecDepartmentCheckExportExcelReq req) throws IOException {
        specDepartmentCheckConfigService.exportExcel(response, req);
        return CostResult.success();
    }
}
